/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class NodeTerminated
implements Predicate<NodeMetadata> {
    private final GetNodeMetadataStrategy client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public NodeTerminated(GetNodeMetadataStrategy client) {
        this.client = client;
    }

    public boolean apply(NodeMetadata node) {
        this.logger.trace("looking for state on node %s", new Object[]{Preconditions.checkNotNull((Object)node, (Object)"node")});
        node = this.refresh(node);
        if (node == null) {
            return true;
        }
        this.logger.trace("%s: looking for node state %s: currently: %s", new Object[]{node.getId(), NodeState.TERMINATED, node.getState()});
        return node.getState() == NodeState.TERMINATED;
    }

    private NodeMetadata refresh(NodeMetadata node) {
        return this.client.getNode(node.getId());
    }
}

