/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.reference;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

public interface ComputeServiceConstants {
    public static final String COMPUTE_LOGGER = "jclouds.compute";
    public static final String LOCAL_PARTITION_GB_PATTERN = "disk_drive/%s/gb";
    public static final String PROPERTY_TIMEOUT_NODE_TERMINATED = "jclouds.compute.timeout.node-terminated";
    public static final String PROPERTY_TIMEOUT_NODE_RUNNING = "jclouds.compute.timeout.node-running";
    public static final String PROPERTY_TIMEOUT_NODE_SUSPENDED = "jclouds.compute.timeout.node-suspended";
    public static final String PROPERTY_TIMEOUT_SCRIPT_COMPLETE = "jclouds.compute.timeout.script-complete";
    public static final String PROPERTY_TIMEOUT_PORT_OPEN = "jclouds.compute.timeout.port-open";
    public static final String PROPERTY_INIT_STATUS_INITIAL_PERIOD = "jclouds.compute.init-status.initial-period";
    public static final String PROPERTY_INIT_STATUS_MAX_PERIOD = "jclouds.compute.init-status.max-period";
    public static final String PROPERTY_IMAGE_ID = "jclouds.image-id";
    public static final String PROPERTY_IMAGE_LOGIN_USER = "jclouds.image.login-user";
    public static final String PROPERTY_IMAGE_AUTHENTICATE_SUDO = "jclouds.image.authenticate-sudo";
    public static final String PROPERTY_BLACKLIST_NODES = "jclouds.compute.blacklist-nodes";
    public static final String PROPERTY_OS_VERSION_MAP_JSON = "jclouds.compute.os-version-map-json";

    @Singleton
    public static class Timeouts {
        @Inject(optional=true)
        @Named(value="jclouds.compute.timeout.node-terminated")
        public long nodeTerminated = 30000L;
        @Inject(optional=true)
        @Named(value="jclouds.compute.timeout.node-running")
        public long nodeRunning = 1200000L;
        @Inject(optional=true)
        @Named(value="jclouds.compute.timeout.node-suspended")
        public long nodeSuspended = 30000L;
        @Inject(optional=true)
        @Named(value="jclouds.compute.timeout.script-complete")
        public long scriptComplete = 600000L;
        @Inject(optional=true)
        @Named(value="jclouds.compute.timeout.port-open")
        public long portOpen = 600000L;
    }

    @Singleton
    public static class ReferenceData {
        @Inject(optional=true)
        @Named(value="jclouds.compute.os-version-map-json")
        public String osVersionMapJson = "{\"suse\":{\"\":\"\",\"11\":\"11\",\"11 SP1\":\"11 SP1\"},\"debian\":{\"\":\"\",\"lenny\":\"5.0\",\"squeeze\":\"6.0\"},\"centos\":{\"\":\"\",\"5\":\"5.0\",\"5.2\":\"5.2\",\"5.3\":\"5.3\",\"5.4\":\"5.4\",\"5.5\":\"5.5\",\"5.6\":\"5.6\",\"5.7\":\"5.7\",\"6.0\":\"6.0\"},\"rhel\":{\"\":\"\",\"5\":\"5.0\",\"5.2\":\"5.2\",\"5.3\":\"5.3\",\"5.4\":\"5.4\",\"5.5\":\"5.5\",\"5.6\":\"5.6\",\"5.7\":\"5.7\",\"6.0\":\"6.0\"},\"solaris\":{\"\":\"\",\"10\":\"10\"},\"ubuntu\":{\"\":\"\",\"hardy\":\"8.04\",\"karmic\":\"9.10\",\"lucid\":\"10.04\",\"10.04.1\":\"10.04\",\"maverick\":\"10.10\",\"natty\":\"11.04\",\"oneiric\":\"11.10\",\"precise\":\"12.04\"},\"windows\":{\"\":\"\",\"7\":\"7\",\"2003\":\"2003\",\"2003 Standard\":\"2003\",\"2003 R2\":\"2003 R2\",\"2008\":\"2008\",\"2008 Web\":\"2008\",\"2008 Server\":\"2008\",\"Server 2008\":\"2008\",\"2008 R1\":\"2008 R1\",\"2008 R2\":\"2008 R2\",\"Server 2008 R2\":\"2008 R2\",\"2008 Server R2\":\"2008 R2\",\"2008 SP2\":\"2008 SP2\",\"Server 2008 SP2\":\"2008 SP2\"}}";
    }

    @Singleton
    public static class InitStatusProperties {
        @Inject(optional=true)
        @Named(value="jclouds.compute.init-status.initial-period")
        public long initStatusInitialPeriod = 500L;
        @Inject(optional=true)
        @Named(value="jclouds.compute.init-status.max-period")
        public long initStatusMaxPeriod = 5000L;
    }
}

