/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class AdaptingComputeServiceStrategies<N, H, I, L>
implements CreateNodeWithGroupEncodedIntoName,
DestroyNodeStrategy,
GetNodeMetadataStrategy,
ListNodesStrategy,
RebootNodeStrategy,
ResumeNodeStrategy,
SuspendNodeStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<String, Credentials> credentialStore;
    private final PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate;
    private final ComputeServiceAdapter<N, H, I, L> client;
    private final Function<N, NodeMetadata> nodeMetadataAdapter;
    private final Function<NodeMetadata, NodeMetadata> addLoginCredentials = new Function<NodeMetadata, NodeMetadata>(){

        public NodeMetadata apply(NodeMetadata arg0) {
            return AdaptingComputeServiceStrategies.this.credentialStore.containsKey("node#" + arg0.getId()) ? NodeMetadataBuilder.fromNodeMetadata(arg0).credentials(LoginCredentials.fromCredentials((Credentials)((Credentials)AdaptingComputeServiceStrategies.this.credentialStore.get("node#" + arg0.getId())))).build() : arg0;
        }

        public String toString() {
            return "addLoginCredentialsFromCredentialStore()";
        }
    };

    @Inject
    public AdaptingComputeServiceStrategies(Map<String, Credentials> credentialStore, PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate, ComputeServiceAdapter<N, H, I, L> client, Function<N, NodeMetadata> nodeMetadataAdapter) {
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.prioritizeCredentialsFromTemplate = (PrioritizeCredentialsFromTemplate)Preconditions.checkNotNull((Object)prioritizeCredentialsFromTemplate, (Object)"prioritizeCredentialsFromTemplate");
        this.client = (ComputeServiceAdapter)Preconditions.checkNotNull(client, (Object)"client");
        this.nodeMetadataAdapter = Functions.compose(this.addLoginCredentials, (Function)((Function)Preconditions.checkNotNull(nodeMetadataAdapter, (Object)"nodeMetadataAdapter")));
    }

    @Override
    public Iterable<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching(NodePredicates.all());
    }

    @Override
    public Iterable<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        return Iterables.filter((Iterable)Iterables.transform(this.client.listNodes(), this.nodeMetadataAdapter), filter);
    }

    @Override
    public NodeMetadata getNode(String id) {
        N node = this.client.getNode((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        if (node == null) {
            return null;
        }
        return (NodeMetadata)this.nodeMetadataAdapter.apply(node);
    }

    @Override
    public NodeMetadata rebootNode(String id) {
        NodeMetadata node = this.getNode((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        if (node == null || node.getState() == NodeState.TERMINATED) {
            return node;
        }
        this.client.rebootNode(id);
        return node;
    }

    @Override
    public NodeMetadata resumeNode(String id) {
        NodeMetadata node = this.getNode((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        if (node == null || node.getState() == NodeState.TERMINATED || node.getState() == NodeState.RUNNING) {
            return node;
        }
        this.client.resumeNode(id);
        return node;
    }

    @Override
    public NodeMetadata suspendNode(String id) {
        NodeMetadata node = this.getNode((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        if (node == null || node.getState() == NodeState.TERMINATED || node.getState() == NodeState.SUSPENDED) {
            return node;
        }
        this.client.suspendNode(id);
        return node;
    }

    @Override
    public NodeMetadata destroyNode(String id) {
        NodeMetadata node = this.getNode((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        if (node == null) {
            return node;
        }
        this.client.destroyNode(id);
        return node;
    }

    @Override
    public NodeMetadata createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Preconditions.checkState((group != null ? 1 : 0) != 0, (Object)"group (that which groups identical nodes together) must be specified");
        Preconditions.checkState((name != null && name.indexOf(group) != -1 ? 1 : 0) != 0, (String)"name should have %s encoded into it", (Object[])new Object[]{group});
        Preconditions.checkState((template != null ? 1 : 0) != 0, (Object)"template was null");
        Preconditions.checkState((template.getOptions() != null ? 1 : 0) != 0, (Object)"template options was null");
        ComputeServiceAdapter.NodeAndInitialCredentials<N> from = this.client.createNodeWithGroupEncodedIntoName(group, name, template);
        LoginCredentials fromNode = from.getCredentials();
        LoginCredentials creds = this.prioritizeCredentialsFromTemplate.apply(template, fromNode);
        if (creds != null) {
            this.credentialStore.put("node#" + from.getNodeId(), (Credentials)creds);
        }
        NodeMetadata node = (NodeMetadata)this.nodeMetadataAdapter.apply(from.getNode());
        return node;
    }
}

