/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class ReturnCredentialsBoundToImage
implements PopulateDefaultLoginCredentialsForImageStrategy {
    protected final LoginCredentials creds;
    protected Map<String, Credentials> credentialStore;

    @Inject
    public ReturnCredentialsBoundToImage(@Nullable @Named(value="image") LoginCredentials creds, Map<String, Credentials> credentialStore) {
        this.creds = creds;
        this.credentialStore = credentialStore;
    }

    @Override
    public LoginCredentials apply(Object resourceToAuthenticate) {
        Preconditions.checkState((boolean)(resourceToAuthenticate instanceof Image), (String)"this is only valid for images, not %s", (Object[])new Object[]{resourceToAuthenticate.getClass().getSimpleName()});
        if (this.creds != null) {
            return this.creds;
        }
        Image image = (Image)Image.class.cast(resourceToAuthenticate);
        if (this.credentialStore.containsKey("image#" + image.getId())) {
            return LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("image#" + image.getId()));
        }
        if (image.getOperatingSystem() != null && OsFamily.WINDOWS.equals((Object)image.getOperatingSystem().getFamily())) {
            return LoginCredentials.builder().user("Administrator").build();
        }
        return LoginCredentials.builder().user("root").build();
    }

    @Override
    public Credentials execute(Object resourceToAuthenticate) {
        return this.apply(resourceToAuthenticate);
    }
}

