/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.stub.config;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.JCloudsNativeComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.stub.config.StubComputeServiceDependenciesModule;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class StubComputeServiceAdapter
implements JCloudsNativeComputeServiceAdapter {
    private final Supplier<Location> location;
    private final ConcurrentMap<String, NodeMetadata> nodes;
    private final ExecutorService ioThreads;
    private final Provider<Integer> idProvider;
    private final String publicIpPrefix;
    private final String privateIpPrefix;
    private final String passwordPrefix;
    private final Supplier<Set<? extends Location>> locationSupplier;
    private final Map<OsFamily, Map<String, String>> osToVersionMap;

    @Inject
    public StubComputeServiceAdapter(ConcurrentMap<String, NodeMetadata> nodes, @Named(value="jclouds.io-worker-threads") ExecutorService ioThreads, Supplier<Location> location, @Named(value="NODE_ID") Provider<Integer> idProvider, @Named(value="PUBLIC_IP_PREFIX") String publicIpPrefix, @Named(value="PRIVATE_IP_PREFIX") String privateIpPrefix, @Named(value="PASSWORD_PREFIX") String passwordPrefix, JustProvider locationSupplier, Map<OsFamily, Map<String, String>> osToVersionMap) {
        this.nodes = nodes;
        this.ioThreads = ioThreads;
        this.location = location;
        this.idProvider = idProvider;
        this.publicIpPrefix = publicIpPrefix;
        this.privateIpPrefix = privateIpPrefix;
        this.passwordPrefix = passwordPrefix;
        this.locationSupplier = locationSupplier;
        this.osToVersionMap = osToVersionMap;
    }

    protected void setStateOnNode(NodeState state, NodeMetadata node) {
        this.nodes.put(node.getId(), NodeMetadataBuilder.fromNodeMetadata(node).state(state).build());
    }

    protected void setStateOnNodeAfterDelay(final NodeState state, final NodeMetadata node, final long millis) {
        if (millis == 0L) {
            this.setStateOnNode(state, node);
        } else {
            this.ioThreads.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Throwables.propagate((Throwable)e);
                    }
                    StubComputeServiceAdapter.this.setStateOnNode(state, node);
                }
            });
        }
    }

    @Override
    public JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        String id = this.idProvider.get() + "";
        builder.ids(id);
        builder.name(name);
        builder.hostname(group);
        builder.tags(template.getOptions().getTags());
        builder.userMetadata((Map)template.getOptions().getUserMetadata());
        builder.group(group);
        builder.location((Location)this.location.get());
        builder.imageId(template.getImage().getId());
        builder.operatingSystem(template.getImage().getOperatingSystem());
        builder.state(NodeState.PENDING);
        builder.publicAddresses((Iterable<String>)ImmutableSet.of((Object)(this.publicIpPrefix + id)));
        builder.privateAddresses((Iterable<String>)ImmutableSet.of((Object)(this.privateIpPrefix + id)));
        builder.credentials(LoginCredentials.builder().user("root").password(this.passwordPrefix + id).build());
        NodeMetadata node = builder.build();
        this.nodes.put(node.getId(), node);
        this.setStateOnNodeAfterDelay(NodeState.RUNNING, node, 100L);
        return new JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials(node);
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        return ImmutableSet.of((Object)StubComputeServiceDependenciesModule.stub("small", 1, 1740, 160.0f), (Object)StubComputeServiceDependenciesModule.stub("medium", 4, 7680, 850.0f), (Object)StubComputeServiceDependenciesModule.stub("large", 8, 15360, 1690.0f));
    }

    @Override
    public Iterable<Image> listImages() {
        ImmutableList.Builder images = ImmutableList.builder();
        int id = 1;
        for (boolean is64Bit : new boolean[]{true, false}) {
            for (Map.Entry<OsFamily, Map<String, String>> osVersions : this.osToVersionMap.entrySet()) {
                for (String version : ImmutableSet.copyOf(osVersions.getValue().values())) {
                    String desc = String.format("stub %s %s", new Object[]{osVersions.getKey(), is64Bit});
                    images.add((Object)new ImageBuilder().ids(id++ + "").name(osVersions.getKey().name()).location((Location)this.location.get()).operatingSystem(new OperatingSystem(osVersions.getKey(), desc, version, null, desc, is64Bit)).description(desc).build());
                }
            }
        }
        return images.build();
    }

    @Override
    public Iterable<NodeMetadata> listNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Location> listLocations() {
        return (Iterable)this.locationSupplier.get();
    }

    @Override
    public NodeMetadata getNode(String id) {
        return (NodeMetadata)this.nodes.get(id);
    }

    @Override
    public void destroyNode(final String id) {
        NodeMetadata node = (NodeMetadata)this.nodes.get(id);
        if (node == null) {
            return;
        }
        this.setStateOnNodeAfterDelay(NodeState.PENDING, node, 0L);
        this.setStateOnNodeAfterDelay(NodeState.TERMINATED, node, 50L);
        this.ioThreads.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Throwables.propagate((Throwable)e);
                }
                finally {
                    StubComputeServiceAdapter.this.nodes.remove(id);
                }
            }
        });
    }

    @Override
    public void rebootNode(String id) {
        NodeMetadata node = (NodeMetadata)this.nodes.get(id);
        if (node == null) {
            throw new ResourceNotFoundException("node not found: " + id);
        }
        this.setStateOnNode(NodeState.PENDING, node);
        this.setStateOnNodeAfterDelay(NodeState.RUNNING, node, 50L);
    }

    @Override
    public void resumeNode(String id) {
        NodeMetadata node = (NodeMetadata)this.nodes.get(id);
        if (node == null) {
            throw new ResourceNotFoundException("node not found: " + id);
        }
        if (node.getState() == NodeState.RUNNING) {
            return;
        }
        if (node.getState() != NodeState.SUSPENDED) {
            throw new IllegalStateException("to resume a node, it must be in suspended state, not: " + (Object)((Object)node.getState()));
        }
        this.setStateOnNode(NodeState.PENDING, node);
        this.setStateOnNodeAfterDelay(NodeState.RUNNING, node, 50L);
    }

    @Override
    public void suspendNode(String id) {
        NodeMetadata node = (NodeMetadata)this.nodes.get(id);
        if (node == null) {
            throw new ResourceNotFoundException("node not found: " + id);
        }
        if (node.getState() == NodeState.SUSPENDED) {
            return;
        }
        if (node.getState() != NodeState.RUNNING) {
            throw new IllegalStateException("to suspend a node, it must be in running state, not: " + (Object)((Object)node.getState()));
        }
        this.setStateOnNode(NodeState.PENDING, node);
        this.setStateOnNodeAfterDelay(NodeState.SUSPENDED, node, 50L);
    }
}

