/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.util.ObjectHelper;

public abstract class RemoteFileEndpoint<T>
extends GenericFileEndpoint<T> {
    private int maximumReconnectAttempts = 3;
    private long reconnectDelay = 1000L;
    private boolean disconnect;
    private boolean fastExistsCheck;

    public RemoteFileEndpoint() {
        this.setReadLockTimeout(20000L);
        this.setReadLockCheckInterval(5000L);
    }

    public RemoteFileEndpoint(String uri, RemoteFileComponent<T> component, RemoteFileConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.setReadLockTimeout(20000L);
        this.setReadLockCheckInterval(5000L);
    }

    public RemoteFileConfiguration getConfiguration() {
        return (RemoteFileConfiguration)this.configuration;
    }

    public Exchange createExchange(GenericFile<T> file) {
        DefaultExchange answer = new DefaultExchange((Endpoint)this);
        if (file != null) {
            file.bindToExchange((Exchange)answer);
        }
        return answer;
    }

    public GenericFileProducer<T> createProducer() throws Exception {
        this.afterPropertiesSet();
        return this.buildProducer();
    }

    public RemoteFileConsumer<T> createConsumer(Processor processor) throws Exception {
        this.afterPropertiesSet();
        RemoteFileConsumer<T> consumer = this.buildConsumer(processor);
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot both set delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotent().booleanValue()) {
            this.log.info("Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotent().booleanValue() && this.idempotentRepository == null) {
            this.log.info("Using default memory based idempotent repository with cache max size: 1000");
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository((int)1000);
        }
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setEagerLimitMaxMessagesPerPoll(this.isEagerMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void afterPropertiesSet() throws Exception {
        RemoteFileConfiguration config = this.getConfiguration();
        ObjectHelper.notEmpty((String)config.getHost(), (String)"host");
        ObjectHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
    }

    protected abstract RemoteFileConsumer<T> buildConsumer(Processor var1);

    protected abstract GenericFileProducer<T> buildProducer();

    public abstract RemoteFileOperations<T> createRemoteFileOperations() throws Exception;

    public String remoteServerInformation() {
        return ((RemoteFileConfiguration)this.configuration).remoteServerInformation();
    }

    public char getFileSeparator() {
        return '/';
    }

    public boolean isAbsolute(String name) {
        return name.startsWith("/");
    }

    public int getMaximumReconnectAttempts() {
        return this.maximumReconnectAttempts;
    }

    public void setMaximumReconnectAttempts(int maximumReconnectAttempts) {
        this.maximumReconnectAttempts = maximumReconnectAttempts;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isFastExistsCheck() {
        return this.fastExistsCheck;
    }

    public void setFastExistsCheck(boolean fastExistsCheck) {
        this.fastExistsCheck = fastExistsCheck;
    }
}

