/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.primitive;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.DataTypeUtil;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CommonTM {
    public static final int GMT_OFFSET_NOT_SET_VALUE = -99;
    private static final HapiLog log = HapiLogFactory.getHapiLog(CommonTM.class);
    private String value;
    private int hour;
    private int minute;
    private int second;
    private float fractionOfSec;
    private int offSet;
    private boolean omitOffsetFg = false;

    public CommonTM() {
        this.value = null;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.fractionOfSec = 0.0f;
        this.offSet = -99;
    }

    public CommonTM(String val) throws DataTypeException {
        this.setValue(val);
    }

    public void setValue(String val) throws DataTypeException {
        if (val != null && !val.equals("") && !val.equals("\"\"")) {
            int d = val.indexOf(".");
            int sp = val.indexOf("+");
            int sm = val.indexOf("-");
            int indexOfSign = -1;
            boolean offsetExists = false;
            if (sp != -1 || sm != -1) {
                offsetExists = true;
            }
            if (sp != -1) {
                indexOfSign = sp;
            }
            if (sm != -1) {
                indexOfSign = sm;
            }
            try {
                String timeVal = val;
                String tempOffset = null;
                if (offsetExists) {
                    timeVal = val.substring(0, indexOfSign);
                    tempOffset = val.substring(indexOfSign);
                }
                if (offsetExists && tempOffset.length() != 5) {
                    String msg = "The length of the TM datatype value does not conform to an allowable format. Format should conform to HH[MM[SS[.S[S[S[S]]]]]][+/-ZZZZ]";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                if (d != -1 && (timeVal.length() < 8 || timeVal.length() > 11)) {
                    String msg = "The length of the TM datatype value does not conform to an allowable format. Format should conform to HH[MM[SS[.S[S[S[S]]]]]][+/-ZZZZ]";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                if (d == -1 && timeVal.length() != 2 && timeVal.length() != 4 && timeVal.length() != 6) {
                    String msg = "The length of the TM datatype value does not conform to an allowable format. Format should conform to HH[MM[SS[.S[S[S[S]]]]]][+/-ZZZZ]";
                    DataTypeException e = new DataTypeException(msg);
                    throw e;
                }
                if (timeVal.length() >= 2) {
                    int hrInt = Integer.parseInt(timeVal.substring(0, 2));
                    if (hrInt < 0 || hrInt > 23) {
                        String msg = "The hour value of the TM datatype must be >=0 and <=23";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.hour = hrInt;
                }
                if (timeVal.length() >= 4) {
                    int minInt = Integer.parseInt(timeVal.substring(2, 4));
                    if (minInt < 0 || minInt > 59) {
                        String msg = "The minute value of the TM datatype must be >=0 and <=59";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.minute = minInt;
                }
                if (timeVal.length() >= 6) {
                    int secInt = Integer.parseInt(timeVal.substring(4, 6));
                    if (secInt < 0 || secInt > 59) {
                        String msg = "The seconds value of the TM datatype must be >=0 and <=59";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.second = secInt;
                }
                if (timeVal.length() >= 8) {
                    float fract = Float.parseFloat(timeVal.substring(6));
                    if (fract < 0.0f || fract >= 1.0f) {
                        String msg = "The fractional second value of the TM datatype must be >= 0 and < 1";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.fractionOfSec = fract;
                }
                if (offsetExists) {
                    this.omitOffsetFg = false;
                    String tempOffsetNoS = tempOffset.substring(1);
                    int offsetInt = Integer.parseInt(tempOffsetNoS.substring(0, 2));
                    if (offsetInt < 0 || offsetInt > 23) {
                        String msg = "The GMT offset hour value of the TM datatype must be >=0 and <=23";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    offsetInt = Integer.parseInt(tempOffsetNoS.substring(2, 4));
                    if (offsetInt < 0 || offsetInt > 59) {
                        String msg = "The GMT offset minute value of the TM datatype must be >=0 and <=59";
                        DataTypeException e = new DataTypeException(msg);
                        throw e;
                    }
                    this.offSet = Integer.parseInt(tempOffsetNoS);
                    if (sm != -1) {
                        this.offSet = -1 * this.offSet;
                    }
                }
                if (!offsetExists) {
                    this.omitOffsetFg = true;
                }
                this.value = timeVal;
            }
            catch (DataTypeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataTypeException(e);
            }
        } else {
            this.value = val;
        }
    }

    public void setHourPrecision(int hr) throws DataTypeException {
        try {
            if (hr < 0 || hr > 23) {
                String msg = "The hour value of the TM datatype must be >=0 and <=23";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            this.hour = hr;
            this.minute = 0;
            this.second = 0;
            this.fractionOfSec = 0.0f;
            this.offSet = 0;
            this.omitOffsetFg = true;
            this.value = DataTypeUtil.preAppendZeroes(hr, 2);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e.getMessage());
        }
    }

    public void setHourMinutePrecision(int hr, int min) throws DataTypeException {
        try {
            this.setHourPrecision(hr);
            if (min < 0 || min > 59) {
                String msg = "The minute value of the TM datatype must be >=0 and <=59";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            this.minute = min;
            this.second = 0;
            this.fractionOfSec = 0.0f;
            this.offSet = 0;
            this.omitOffsetFg = true;
            this.value = this.value + DataTypeUtil.preAppendZeroes(min, 2);
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e.getMessage());
        }
    }

    public void setHourMinSecondPrecision(int hr, int min, float sec) throws DataTypeException {
        try {
            this.setHourMinutePrecision(hr, min);
            int secMultRound = Math.round(10000.0f * sec);
            sec = (float)secMultRound / 10000.0f;
            this.second = (int)Math.floor(sec);
            if (this.second < 0 || this.second >= 60) {
                String msg = "The (rounded) second value of the TM datatype must be >=0 and <60";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            int fractionOfSecInt = secMultRound - this.second * 10000;
            this.fractionOfSec = (float)fractionOfSecInt / 10000.0f;
            String fractString = "";
            if (this.fractionOfSec != 0.0f) {
                fractString = Float.toString(this.fractionOfSec).substring(1);
            }
            this.offSet = 0;
            this.omitOffsetFg = true;
            this.value = this.value + DataTypeUtil.preAppendZeroes(this.second, 2) + fractString;
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public void setOffset(int signedOffset) throws DataTypeException {
        try {
            this.omitOffsetFg = false;
            String offsetStr = Integer.toString(signedOffset);
            if (signedOffset >= 0 && offsetStr.length() > 4 || signedOffset < 0 && offsetStr.length() > 5) {
                String msg = "The length of the GMT offset for the TM datatype value does not conform to the allowable format [+/-ZZZZ]. Value: " + signedOffset;
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            int absOffset = Math.abs(signedOffset);
            offsetStr = DataTypeUtil.preAppendZeroes(absOffset, 4);
            int hrOffsetInt = Integer.parseInt(offsetStr.substring(0, 2));
            if (hrOffsetInt < 0 || hrOffsetInt > 23) {
                String msg = "The GMT offset hour value of the TM datatype must be >=0 and <=23";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            int minOffsetInt = Integer.parseInt(offsetStr.substring(2, 4));
            if (minOffsetInt < 0 || minOffsetInt > 59) {
                String msg = "The GMT offset minute value of the TM datatype must be >=0 and <=59";
                DataTypeException e = new DataTypeException(msg);
                throw e;
            }
            this.offSet = signedOffset;
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
    }

    public String getValue() {
        String returnVal = null;
        if (this.value != null && !this.value.equals("")) {
            if (!this.omitOffsetFg && !this.value.equals("\"\"")) {
                int absOffset = Math.abs(this.offSet);
                String sign = "";
                sign = this.offSet >= 0 ? "+" : "-";
                returnVal = this.value + sign + DataTypeUtil.preAppendZeroes(absOffset, 4);
            } else {
                returnVal = this.value;
            }
        }
        return returnVal;
    }

    public void setValueToMinute(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        this.setHourMinutePrecision(hr, min);
    }

    public void setValueToMinute(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        this.setValueToMinute(calendar);
    }

    public void setValueToSecond(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        int sec = theCalendar.get(13);
        this.setHourMinSecondPrecision(hr, min, sec);
    }

    public void setValue(Calendar theCalendar) throws DataTypeException {
        if (theCalendar == null) {
            this.setValue((String)null);
            return;
        }
        int hr = theCalendar.get(11);
        int min = theCalendar.get(12);
        float sec = (float)theCalendar.get(13) + (float)theCalendar.get(14) / 1000.0f;
        this.setHourMinSecondPrecision(hr, min, sec);
        int zoneOffset = theCalendar.get(15) * 100 / 3600000;
        this.setOffset(zoneOffset);
    }

    public void setValue(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(theDate);
        this.setValue(cal);
    }

    public void setValueToSecond(Date theDate) throws DataTypeException {
        if (theDate == null) {
            this.setValue((String)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        this.setValueToSecond(calendar);
    }

    public Calendar getValueAsCalendar() {
        Calendar retVal = Calendar.getInstance();
        retVal.set(11, this.getHour());
        retVal.set(12, this.getMinute());
        retVal.set(13, this.getSecond());
        float fractSecond = this.getFractSecond();
        retVal.set(14, (int)((double)fractSecond * 1000.0));
        int gmtOff = this.getGMTOffset();
        if (gmtOff != -99 && !this.omitOffsetFg) {
            retVal.set(15, gmtOff / 100 * 3600000);
        }
        return retVal;
    }

    public Date getValueAsDate() {
        return this.getValueAsCalendar().getTime();
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public float getFractSecond() {
        return this.fractionOfSec;
    }

    public int getGMTOffset() {
        return this.offSet;
    }

    public static String toHl7TMFormat(GregorianCalendar cal) throws DataTypeException {
        String val = "";
        try {
            cal.setLenient(false);
            int calHour = cal.get(11);
            int calMin = cal.get(12);
            int calSec = cal.get(13);
            int calMilli = cal.get(14);
            float fractSec = (float)calMilli / 1000.0f;
            float calSecFloat = (float)calSec + fractSec;
            int calOffset = cal.get(15) + cal.get(16);
            int offSetSignInt = calOffset < 0 ? -1 : 1;
            int absGmtOffSet = Math.abs(calOffset);
            int gmtOffSetHours = absGmtOffSet / 3600000;
            int gmtOffSetMin = absGmtOffSet / 60000 % 60;
            calOffset = (gmtOffSetHours * 100 + gmtOffSetMin) * offSetSignInt;
            CommonTM tm = new CommonTM();
            tm.setHourMinSecondPrecision(calHour, calMin, calSecFloat);
            tm.setOffset(calOffset);
            val = tm.getValue();
        }
        catch (DataTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeException(e);
        }
        return val;
    }
}

