/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.AD;
import ca.uhn.hl7v2.model.v21.datatype.PN;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class NK1
extends AbstractSegment {
    public NK1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "SET ID - NEXT OF KIN");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage(), new Integer(0)}, "NEXT OF KIN NAME");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage(), new Integer(63)}, "NEXT OF KIN RELATIONSHIP");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage(), new Integer(0)}, "NEXT OF KIN - ADDRESS");
            this.add(TN.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(0)}, "NEXT OF KIN - PHONE NUMBER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NK1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSETIDNEXTOFKIN() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getNk11_SETIDNEXTOFKIN() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PN getNEXTOFKINNAME() {
        PN ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PN getNk12_NEXTOFKINNAME() {
        PN ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNEXTOFKINRELATIONSHIP() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNk13_NEXTOFKINRELATIONSHIP() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public AD getNEXTOFKINADDRESS() {
        AD ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (AD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public AD getNk14_NEXTOFKINADDRESS() {
        AD ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (AD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TN[] getNEXTOFKINPHONENUMBER() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNEXTOFKINPHONENUMBERReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public TN getNEXTOFKINPHONENUMBER(int rep) {
        TN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (TN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TN getNk15_NEXTOFKINPHONENUMBER(int rep) {
        TN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (TN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk15_NEXTOFKINPHONENUMBERReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public TN insertNEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN insertNk15_NEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(5, rep);
    }

    public TN removeNEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    public TN removeNk15_NEXTOFKINPHONENUMBER(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new PN(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new AD(this.getMessage());
            }
            case 4: {
                return new TN(this.getMessage());
            }
        }
        return null;
    }
}

