/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.group.NMD_N01_CLOCK_AND_STATS_WITH_NOTES;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class NMD_N01
extends AbstractMessage {
    public NMD_N01() {
        this(new DefaultModelClassFactory());
    }

    public NMD_N01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NMD_N01_CLOCK_AND_STATS_WITH_NOTES.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMD_N01 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMD_N01_CLOCK_AND_STATS_WITH_NOTES getCLOCK_AND_STATS_WITH_NOTES() {
        NMD_N01_CLOCK_AND_STATS_WITH_NOTES ret = null;
        try {
            ret = (NMD_N01_CLOCK_AND_STATS_WITH_NOTES)this.get("CLOCK_AND_STATS_WITH_NOTES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMD_N01_CLOCK_AND_STATS_WITH_NOTES getCLOCK_AND_STATS_WITH_NOTES(int rep) {
        NMD_N01_CLOCK_AND_STATS_WITH_NOTES ret = null;
        try {
            ret = (NMD_N01_CLOCK_AND_STATS_WITH_NOTES)this.get("CLOCK_AND_STATS_WITH_NOTES", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCLOCK_AND_STATS_WITH_NOTESReps() {
        int reps = -1;
        try {
            reps = this.getAll("CLOCK_AND_STATS_WITH_NOTES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCLOCK_AND_STATS_WITH_NOTES(NMD_N01_CLOCK_AND_STATS_WITH_NOTES structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES", structure, rep);
    }

    public NMD_N01_CLOCK_AND_STATS_WITH_NOTES insertCLOCK_AND_STATS_WITH_NOTES(int rep) throws HL7Exception {
        return (NMD_N01_CLOCK_AND_STATS_WITH_NOTES)super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES", rep);
    }

    public NMD_N01_CLOCK_AND_STATS_WITH_NOTES removeCLOCK_AND_STATS_WITH_NOTES(int rep) throws HL7Exception {
        return (NMD_N01_CLOCK_AND_STATS_WITH_NOTES)super.removeRepetition("CLOCK_AND_STATS_WITH_NOTES", rep);
    }
}

