/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v22.group.NMQ_N02_CLOCK_AND_STATISTICS;
import ca.uhn.hl7v2.model.v22.group.NMQ_N02_QRY_WITH_DETAIL;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class NMQ_N02
extends AbstractMessage {
    public NMQ_N02() {
        this(new DefaultModelClassFactory());
    }

    public NMQ_N02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NMQ_N02_QRY_WITH_DETAIL.class, false, false);
            this.add(NMQ_N02_CLOCK_AND_STATISTICS.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMQ_N02 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N02_QRY_WITH_DETAIL getQRY_WITH_DETAIL() {
        NMQ_N02_QRY_WITH_DETAIL ret = null;
        try {
            ret = (NMQ_N02_QRY_WITH_DETAIL)this.get("QRY_WITH_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N02_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS() {
        NMQ_N02_CLOCK_AND_STATISTICS ret = null;
        try {
            ret = (NMQ_N02_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NMQ_N02_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS(int rep) {
        NMQ_N02_CLOCK_AND_STATISTICS ret = null;
        try {
            ret = (NMQ_N02_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCLOCK_AND_STATISTICSReps() {
        int reps = -1;
        try {
            reps = this.getAll("CLOCK_AND_STATISTICS").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCLOCK_AND_STATISTICS(NMQ_N02_CLOCK_AND_STATISTICS structure, int rep) throws HL7Exception {
        super.insertRepetition("CLOCK_AND_STATISTICS", structure, rep);
    }

    public NMQ_N02_CLOCK_AND_STATISTICS insertCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N02_CLOCK_AND_STATISTICS)super.insertRepetition("CLOCK_AND_STATISTICS", rep);
    }

    public NMQ_N02_CLOCK_AND_STATISTICS removeCLOCK_AND_STATISTICS(int rep) throws HL7Exception {
        return (NMQ_N02_CLOCK_AND_STATISTICS)super.removeRepetition("CLOCK_AND_STATISTICS", rep);
    }
}

