/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.MFN_M05_MF_LOC_DEPT;
import ca.uhn.hl7v2.model.v23.segment.LCH;
import ca.uhn.hl7v2.model.v23.segment.LOC;
import ca.uhn.hl7v2.model.v23.segment.LRL;
import ca.uhn.hl7v2.model.v23.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M05_MF_LOCATION
extends AbstractGroup {
    public MFN_M05_MF_LOCATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(LOC.class, true, false);
            this.add(LCH.class, false, true);
            this.add(LRL.class, false, true);
            this.add(MFN_M05_MF_LOC_DEPT.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M05_MF_LOCATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LOC getLOC() {
        LOC ret = null;
        try {
            ret = (LOC)this.get("LOC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH() {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH(int rep) {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLCHReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCH").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL ret = null;
        try {
            ret = (LRL)this.get("LRL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LRL getLRL(int rep) {
        LRL ret = null;
        try {
            ret = (LRL)this.get("LRL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLRLReps() {
        int reps = -1;
        try {
            reps = this.getAll("LRL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition("LRL", structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public MFN_M05_MF_LOC_DEPT getMF_LOC_DEPT() {
        MFN_M05_MF_LOC_DEPT ret = null;
        try {
            ret = (MFN_M05_MF_LOC_DEPT)this.get("MF_LOC_DEPT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M05_MF_LOC_DEPT getMF_LOC_DEPT(int rep) {
        MFN_M05_MF_LOC_DEPT ret = null;
        try {
            ret = (MFN_M05_MF_LOC_DEPT)this.get("MF_LOC_DEPT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMF_LOC_DEPTReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_LOC_DEPT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMF_LOC_DEPT(MFN_M05_MF_LOC_DEPT structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_LOC_DEPT", structure, rep);
    }

    public MFN_M05_MF_LOC_DEPT insertMF_LOC_DEPT(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOC_DEPT)super.insertRepetition("MF_LOC_DEPT", rep);
    }

    public MFN_M05_MF_LOC_DEPT removeMF_LOC_DEPT(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOC_DEPT)super.removeRepetition("MF_LOC_DEPT", rep);
    }
}

