/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.PGL_PC7_GOAL_ROLE;
import ca.uhn.hl7v2.model.v23.group.PGL_PC7_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.PGL_PC7_ORDER;
import ca.uhn.hl7v2.model.v23.group.PGL_PC7_PATHWAY;
import ca.uhn.hl7v2.model.v23.group.PGL_PC7_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.GOL;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PGL_PC7_GOAL
extends AbstractGroup {
    public PGL_PC7_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PGL_PC7_GOAL_ROLE.class, false, true);
            this.add(PGL_PC7_PATHWAY.class, false, true);
            this.add(PGL_PC7_OBSERVATION.class, false, true);
            this.add(PGL_PC7_PROBLEM.class, false, true);
            this.add(PGL_PC7_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PGL_PC7_GOAL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public GOL getGOL() {
        GOL ret = null;
        try {
            ret = (GOL)this.get("GOL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PGL_PC7_GOAL_ROLE getGOAL_ROLE() {
        PGL_PC7_GOAL_ROLE ret = null;
        try {
            ret = (PGL_PC7_GOAL_ROLE)this.get("GOAL_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC7_GOAL_ROLE getGOAL_ROLE(int rep) {
        PGL_PC7_GOAL_ROLE ret = null;
        try {
            ret = (PGL_PC7_GOAL_ROLE)this.get("GOAL_ROLE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_ROLE(PGL_PC7_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", structure, rep);
    }

    public PGL_PC7_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PGL_PC7_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PGL_PC7_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PGL_PC7_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PGL_PC7_PATHWAY getPATHWAY() {
        PGL_PC7_PATHWAY ret = null;
        try {
            ret = (PGL_PC7_PATHWAY)this.get("PATHWAY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC7_PATHWAY getPATHWAY(int rep) {
        PGL_PC7_PATHWAY ret = null;
        try {
            ret = (PGL_PC7_PATHWAY)this.get("PATHWAY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATHWAY(PGL_PC7_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", structure, rep);
    }

    public PGL_PC7_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PGL_PC7_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PGL_PC7_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PGL_PC7_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }

    public PGL_PC7_OBSERVATION getOBSERVATION() {
        PGL_PC7_OBSERVATION ret = null;
        try {
            ret = (PGL_PC7_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC7_OBSERVATION getOBSERVATION(int rep) {
        PGL_PC7_OBSERVATION ret = null;
        try {
            ret = (PGL_PC7_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(PGL_PC7_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public PGL_PC7_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (PGL_PC7_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public PGL_PC7_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (PGL_PC7_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public PGL_PC7_PROBLEM getPROBLEM() {
        PGL_PC7_PROBLEM ret = null;
        try {
            ret = (PGL_PC7_PROBLEM)this.get("PROBLEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC7_PROBLEM getPROBLEM(int rep) {
        PGL_PC7_PROBLEM ret = null;
        try {
            ret = (PGL_PC7_PROBLEM)this.get("PROBLEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM(PGL_PC7_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public PGL_PC7_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PGL_PC7_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PGL_PC7_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PGL_PC7_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PGL_PC7_ORDER getORDER() {
        PGL_PC7_ORDER ret = null;
        try {
            ret = (PGL_PC7_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC7_ORDER getORDER(int rep) {
        PGL_PC7_ORDER ret = null;
        try {
            ret = (PGL_PC7_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(PGL_PC7_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public PGL_PC7_ORDER insertORDER(int rep) throws HL7Exception {
        return (PGL_PC7_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PGL_PC7_ORDER removeORDER(int rep) throws HL7Exception {
        return (PGL_PC7_ORDER)super.removeRepetition("ORDER", rep);
    }
}

