/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_GOAL_PATHWAY;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_GOAL_ROLE;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_ORDER;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.GOL;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPV_PCA_GOAL
extends AbstractGroup {
    public PPV_PCA_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPV_PCA_GOAL_ROLE.class, false, true);
            this.add(PPV_PCA_GOAL_PATHWAY.class, false, true);
            this.add(PPV_PCA_GOAL_OBSERVATION.class, false, true);
            this.add(PPV_PCA_PROBLEM.class, false, true);
            this.add(PPV_PCA_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPV_PCA_GOAL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public GOL getGOL() {
        GOL ret = null;
        try {
            ret = (GOL)this.get("GOL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPV_PCA_GOAL_ROLE getGOAL_ROLE() {
        PPV_PCA_GOAL_ROLE ret = null;
        try {
            ret = (PPV_PCA_GOAL_ROLE)this.get("GOAL_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPV_PCA_GOAL_ROLE ret = null;
        try {
            ret = (PPV_PCA_GOAL_ROLE)this.get("GOAL_ROLE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_ROLE(PPV_PCA_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", structure, rep);
    }

    public PPV_PCA_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPV_PCA_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPV_PCA_GOAL_PATHWAY getGOAL_PATHWAY() {
        PPV_PCA_GOAL_PATHWAY ret = null;
        try {
            ret = (PPV_PCA_GOAL_PATHWAY)this.get("GOAL_PATHWAY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL_PATHWAY getGOAL_PATHWAY(int rep) {
        PPV_PCA_GOAL_PATHWAY ret = null;
        try {
            ret = (PPV_PCA_GOAL_PATHWAY)this.get("GOAL_PATHWAY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_PATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_PATHWAY(PPV_PCA_GOAL_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_PATHWAY", structure, rep);
    }

    public PPV_PCA_GOAL_PATHWAY insertGOAL_PATHWAY(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_PATHWAY)super.insertRepetition("GOAL_PATHWAY", rep);
    }

    public PPV_PCA_GOAL_PATHWAY removeGOAL_PATHWAY(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_PATHWAY)super.removeRepetition("GOAL_PATHWAY", rep);
    }

    public PPV_PCA_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPV_PCA_GOAL_OBSERVATION ret = null;
        try {
            ret = (PPV_PCA_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPV_PCA_GOAL_OBSERVATION ret = null;
        try {
            ret = (PPV_PCA_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_OBSERVATION(PPV_PCA_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", structure, rep);
    }

    public PPV_PCA_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPV_PCA_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }

    public PPV_PCA_PROBLEM getPROBLEM() {
        PPV_PCA_PROBLEM ret = null;
        try {
            ret = (PPV_PCA_PROBLEM)this.get("PROBLEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_PROBLEM getPROBLEM(int rep) {
        PPV_PCA_PROBLEM ret = null;
        try {
            ret = (PPV_PCA_PROBLEM)this.get("PROBLEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM(PPV_PCA_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public PPV_PCA_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPV_PCA_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPV_PCA_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPV_PCA_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PPV_PCA_ORDER getORDER() {
        PPV_PCA_ORDER ret = null;
        try {
            ret = (PPV_PCA_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_ORDER getORDER(int rep) {
        PPV_PCA_ORDER ret = null;
        try {
            ret = (PPV_PCA_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(PPV_PCA_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public PPV_PCA_ORDER insertORDER(int rep) throws HL7Exception {
        return (PPV_PCA_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PPV_PCA_ORDER removeORDER(int rep) throws HL7Exception {
        return (PPV_PCA_ORDER)super.removeRepetition("ORDER", rep);
    }
}

