/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_GOAL;
import ca.uhn.hl7v2.model.v23.group.PPV_PCA_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPV_PCA_PATIENT
extends AbstractGroup {
    public PPV_PCA_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PPV_PCA_PATIENT_VISIT.class, false, false);
            this.add(PPV_PCA_GOAL.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPV_PCA_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_PATIENT_VISIT getPATIENT_VISIT() {
        PPV_PCA_PATIENT_VISIT ret = null;
        try {
            ret = (PPV_PCA_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL getGOAL() {
        PPV_PCA_GOAL ret = null;
        try {
            ret = (PPV_PCA_GOAL)this.get("GOAL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL getGOAL(int rep) {
        PPV_PCA_GOAL ret = null;
        try {
            ret = (PPV_PCA_GOAL)this.get("GOAL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOALReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL(PPV_PCA_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", structure, rep);
    }

    public PPV_PCA_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PPV_PCA_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL)super.removeRepetition("GOAL", rep);
    }
}

