/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.ROR_ROR_ORDER;
import ca.uhn.hl7v2.model.v23.group.ROR_ROR_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.QRD;
import ca.uhn.hl7v2.model.v23.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ROR_ROR_DEFINITION
extends AbstractGroup {
    public ROR_ROR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(ROR_ROR_PATIENT.class, false, false);
            this.add(ROR_ROR_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ROR_ROR_DEFINITION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public QRD getQRD() {
        QRD ret = null;
        try {
            ret = (QRD)this.get("QRD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QRF getQRF() {
        QRF ret = null;
        try {
            ret = (QRF)this.get("QRF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROR_ROR_PATIENT getPATIENT() {
        ROR_ROR_PATIENT ret = null;
        try {
            ret = (ROR_ROR_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROR_ROR_ORDER getORDER() {
        ROR_ROR_ORDER ret = null;
        try {
            ret = (ROR_ROR_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROR_ROR_ORDER getORDER(int rep) {
        ROR_ROR_ORDER ret = null;
        try {
            ret = (ROR_ROR_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(ROR_ROR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public ROR_ROR_ORDER insertORDER(int rep) throws HL7Exception {
        return (ROR_ROR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ROR_ROR_ORDER removeORDER(int rep) throws HL7Exception {
        return (ROR_ROR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

