/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.MFN_M05_MF_LOCATION;
import ca.uhn.hl7v2.model.v23.segment.MFI;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M05
extends AbstractMessage {
    public MFN_M05() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M05_MF_LOCATION.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M05 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M05_MF_LOCATION getMF_LOCATION() {
        MFN_M05_MF_LOCATION ret = null;
        try {
            ret = (MFN_M05_MF_LOCATION)this.get("MF_LOCATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M05_MF_LOCATION getMF_LOCATION(int rep) {
        MFN_M05_MF_LOCATION ret = null;
        try {
            ret = (MFN_M05_MF_LOCATION)this.get("MF_LOCATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMF_LOCATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_LOCATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMF_LOCATION(MFN_M05_MF_LOCATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_LOCATION", structure, rep);
    }

    public MFN_M05_MF_LOCATION insertMF_LOCATION(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOCATION)super.insertRepetition("MF_LOCATION", rep);
    }

    public MFN_M05_MF_LOCATION removeMF_LOCATION(int rep) throws HL7Exception {
        return (MFN_M05_MF_LOCATION)super.removeRepetition("MF_LOCATION", rep);
    }
}

