/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CM_DDI;
import ca.uhn.hl7v2.model.v23.datatype.CM_PTA;
import ca.uhn.hl7v2.model.v23.datatype.CM_RMC;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.JCC;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class IN2
extends AbstractSegment {
    public IN2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CX.class, false, 1, 59, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Employee ID");
            this.add(ST.class, false, 1, 11, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Social Security Number");
            this.add(XCN.class, false, 1, 130, new Object[]{this.getMessage(), new Integer(0)}, "Insured's Employer Name");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Employer Information Data");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Mail Claim Party");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage(), new Integer(0)}, "Medicare Health Ins Card Number");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage(), new Integer(0)}, "Medicaid Case Name");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage(), new Integer(0)}, "Medicaid Case Number");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage(), new Integer(0)}, "Champus Sponsor Name");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Champus ID Number");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(0)}, "Dependent of Champus Recipient");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage(), new Integer(0)}, "Champus Organization");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage(), new Integer(0)}, "Champus Station");
            this.add(IS.class, false, 1, 14, new Object[]{this.getMessage()}, "Champus Service");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Champus Rank/Grade");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage()}, "Champus Status");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Champus Retire Date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Champus Non-Avail Cert on File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Baby Coverage");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Combine Baby Bill");
            this.add(ST.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Blood Deductible");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage(), new Integer(0)}, "Special Coverage Approval Name");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(0)}, "Special Coverage Approval Title");
            this.add(ST.class, false, 0, 8, new Object[]{this.getMessage(), new Integer(143)}, "Non-Covered Insurance Code");
            this.add(CX.class, false, 1, 59, new Object[]{this.getMessage(), new Integer(0)}, "Payor ID");
            this.add(CX.class, false, 1, 59, new Object[]{this.getMessage(), new Integer(0)}, "Payor Subscriber ID");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Eligibility Source");
            this.add(CM_RMC.class, false, 0, 25, new Object[]{this.getMessage(), new Integer(0)}, "Room Coverage Type/Amount");
            this.add(CM_PTA.class, false, 0, 25, new Object[]{this.getMessage(), new Integer(0)}, "Policy Type/Amount");
            this.add(CM_DDI.class, false, 1, 25, new Object[]{this.getMessage(), new Integer(0)}, "Daily Deductible");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Living Dependency");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Ambulatory Status");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage()}, "Citizenship");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(296)}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Living Arrangement");
            this.add(CE.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(215)}, "Publicity Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Student Indicator");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage()}, "Religion");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage(), new Integer(0)}, "Mother\u2019s Maiden Name");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(212)}, "Nationality Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Ethnic Group");
            this.add(IS.class, false, 0, 1, new Object[]{this.getMessage()}, "Marital Status");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Employment Start Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Employment Stop Date");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Job Code/Class");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Job Status");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage(), new Integer(0)}, "Employer Contact Person Name");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(0)}, "Employer Contact Person Phone Number");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Employer Contact Reason");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage(), new Integer(0)}, "Insured\u2019s Contact Person\u2019s Name");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(0)}, "Insured\u2019s Contact Person Telephone Number");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage()}, "Insured\u2019s Contact Person Reason");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Relationship To The Patient Start Date");
            this.add(DT.class, false, 0, 8, new Object[]{this.getMessage(), new Integer(0)}, "Relationship To The Patient Stop Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Insurance Co. Contact Reason");
            this.add(XTN.class, false, 1, 40, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Co. Contact Phone Number");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Policy Scope");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Policy Source");
            this.add(CX.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Patient Member Number");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Guarantor\u2019s Relationship To Insured");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(0)}, "Insured\u2019s Telephone Number - Home");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage(), new Integer(0)}, "Insured\u2019s Employer Telephone Number");
            this.add(CE.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Military Handicapped Program");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage()}, "Suspend Flag");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage()}, "Co-pay Limit Flag");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage()}, "Stoploss Limit Flag");
            this.add(XON.class, false, 0, 130, new Object[]{this.getMessage(), new Integer(0)}, "Insured Organization Name And ID");
            this.add(XON.class, false, 0, 130, new Object[]{this.getMessage(), new Integer(0)}, "Insured Employer Organization Name And ID");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Race");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Patient Relationship to Insured");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IN2 - this is probably a bug in the source code generator.", e);
        }
    }

    public CX getInsuredSEmployeeID() {
        CX ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn21_InsuredSEmployeeID() {
        CX ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getInsuredSSocialSecurityNumber() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn22_InsuredSSocialSecurityNumber() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getInsuredSEmployerName() {
        XCN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getIn23_InsuredSEmployerName() {
        XCN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getEmployerInformationData() {
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn24_EmployerInformationData() {
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getMailClaimParty() {
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn25_MailClaimParty() {
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getMedicareHealthInsCardNumber() {
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn26_MedicareHealthInsCardNumber() {
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getMedicaidCaseName() {
        XPN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn27_MedicaidCaseName() {
        XPN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getMedicaidCaseNumber() {
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn28_MedicaidCaseNumber() {
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getChampusSponsorName() {
        XPN ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn29_ChampusSponsorName() {
        XPN ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getChampusIDNumber() {
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn210_ChampusIDNumber() {
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getDependentOfChampusRecipient() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn211_DependentOfChampusRecipient() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getChampusOrganization() {
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn212_ChampusOrganization() {
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getChampusStation() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn213_ChampusStation() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getChampusService() {
        IS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn214_ChampusService() {
        IS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getChampusRankGrade() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn215_ChampusRankGrade() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getChampusStatus() {
        IS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn216_ChampusStatus() {
        IS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getChampusRetireDate() {
        DT ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn217_ChampusRetireDate() {
        DT ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getChampusNonAvailCertOnFile() {
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn218_ChampusNonAvailCertOnFile() {
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getBabyCoverage() {
        ID ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn219_BabyCoverage() {
        ID ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getCombineBabyBill() {
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn220_CombineBabyBill() {
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getBloodDeductible() {
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn221_BloodDeductible() {
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getSpecialCoverageApprovalName() {
        XPN ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn222_SpecialCoverageApprovalName() {
        XPN ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getSpecialCoverageApprovalTitle() {
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn223_SpecialCoverageApprovalTitle() {
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST[] getNonCoveredInsuranceCode() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(24);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNonCoveredInsuranceCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ST getNonCoveredInsuranceCode(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn224_NonCoveredInsuranceCode(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn224_NonCoveredInsuranceCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ST insertNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(24, rep);
    }

    public ST insertIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(24, rep);
    }

    public ST removeNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(24, rep);
    }

    public ST removeIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(24, rep);
    }

    public CX getPayorID() {
        CX ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn225_PayorID() {
        CX ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPayorSubscriberID() {
        CX ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn226_PayorSubscriberID() {
        CX ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getEligibilitySource() {
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn227_EligibilitySource() {
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_RMC[] getRoomCoverageTypeAmount() {
        CM_RMC[] ret = null;
        try {
            Type[] t = this.getField(28);
            ret = new CM_RMC[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_RMC)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRoomCoverageTypeAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_RMC getRoomCoverageTypeAmount(int rep) {
        CM_RMC ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CM_RMC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_RMC getIn228_RoomCoverageTypeAmount(int rep) {
        CM_RMC ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CM_RMC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn228_RoomCoverageTypeAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_RMC insertRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.insertRepetition(28, rep);
    }

    public CM_RMC insertIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.insertRepetition(28, rep);
    }

    public CM_RMC removeRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.removeRepetition(28, rep);
    }

    public CM_RMC removeIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.removeRepetition(28, rep);
    }

    public CM_PTA[] getPolicyTypeAmount() {
        CM_PTA[] ret = null;
        try {
            Type[] t = this.getField(29);
            ret = new CM_PTA[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_PTA)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPolicyTypeAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PTA getPolicyTypeAmount(int rep) {
        CM_PTA ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CM_PTA)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_PTA getIn229_PolicyTypeAmount(int rep) {
        CM_PTA ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CM_PTA)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn229_PolicyTypeAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PTA insertPolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.insertRepetition(29, rep);
    }

    public CM_PTA insertIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.insertRepetition(29, rep);
    }

    public CM_PTA removePolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.removeRepetition(29, rep);
    }

    public CM_PTA removeIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.removeRepetition(29, rep);
    }

    public CM_DDI getDailyDeductible() {
        CM_DDI ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CM_DDI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_DDI getIn230_DailyDeductible() {
        CM_DDI ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CM_DDI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getLivingDependency() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn231_LivingDependency() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAmbulatoryStatus() {
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn232_AmbulatoryStatus() {
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCitizenship() {
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn233_Citizenship() {
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPrimaryLanguage() {
        CE ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn234_PrimaryLanguage() {
        CE ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getLivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn235_LivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPublicityIndicator() {
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn236_PublicityIndicator() {
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn237_ProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getStudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn238_StudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getReligion() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn239_Religion() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getMotherSMaidenName() {
        XPN ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn240_MotherSMaidenName() {
        XPN ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getNationalityCode() {
        CE ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn241_NationalityCode() {
        CE ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getEthnicGroup() {
        IS ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn242_EthnicGroup() {
        IS ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS[] getMaritalStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(43);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMaritalStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(43);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public IS getMaritalStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(43, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn243_MaritalStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(43, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn243_MaritalStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(43);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public IS insertMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(43, rep);
    }

    public IS insertIn243_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(43, rep);
    }

    public IS removeMaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(43, rep);
    }

    public IS removeIn243_MaritalStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(43, rep);
    }

    public DT getEmploymentStartDate() {
        DT ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn244_EmploymentStartDate() {
        DT ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getEmploymentStopDate() {
        DT ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn245_EmploymentStopDate() {
        DT ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getJobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIn246_JobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getJobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getIn247_JobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getJobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn248_JobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getEmployerContactPersonName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(49);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEmployerContactPersonNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(49);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XPN getEmployerContactPersonName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn249_EmployerContactPersonName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn249_EmployerContactPersonNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(49);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertEmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(49, rep);
    }

    public XPN insertIn249_EmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(49, rep);
    }

    public XPN removeEmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(49, rep);
    }

    public XPN removeIn249_EmployerContactPersonName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(49, rep);
    }

    public XTN[] getEmployerContactPersonPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(50);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEmployerContactPersonPhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(50);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN getEmployerContactPersonPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(50, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn250_EmployerContactPersonPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(50, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn250_EmployerContactPersonPhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(50);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertEmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(50, rep);
    }

    public XTN insertIn250_EmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(50, rep);
    }

    public XTN removeEmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(50, rep);
    }

    public XTN removeIn250_EmployerContactPersonPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(50, rep);
    }

    public IS getEmployerContactReason() {
        IS ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn251_EmployerContactReason() {
        IS ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getInsuredSContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(52);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredSContactPersonSNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(52);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XPN getInsuredSContactPersonSName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(52, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getIn252_InsuredSContactPersonSName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(52, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn252_InsuredSContactPersonSNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(52);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertInsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(52, rep);
    }

    public XPN insertIn252_InsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(52, rep);
    }

    public XPN removeInsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(52, rep);
    }

    public XPN removeIn252_InsuredSContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(52, rep);
    }

    public XTN[] getInsuredSContactPersonTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(53);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredSContactPersonTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(53);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN getInsuredSContactPersonTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(53, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn253_InsuredSContactPersonTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(53, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn253_InsuredSContactPersonTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(53);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertInsuredSContactPersonTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(53, rep);
    }

    public XTN insertIn253_InsuredSContactPersonTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(53, rep);
    }

    public XTN removeInsuredSContactPersonTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(53, rep);
    }

    public XTN removeIn253_InsuredSContactPersonTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(53, rep);
    }

    public IS[] getInsuredSContactPersonReason() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(54);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredSContactPersonReasonReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(54);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public IS getInsuredSContactPersonReason(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(54, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn254_InsuredSContactPersonReason(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(54, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn254_InsuredSContactPersonReasonReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(54);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public IS insertInsuredSContactPersonReason(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(54, rep);
    }

    public IS insertIn254_InsuredSContactPersonReason(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(54, rep);
    }

    public IS removeInsuredSContactPersonReason(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(54, rep);
    }

    public IS removeIn254_InsuredSContactPersonReason(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(54, rep);
    }

    public DT getRelationshipToThePatientStartDate() {
        DT ret = null;
        try {
            Type t = this.getField(55, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn255_RelationshipToThePatientStartDate() {
        DT ret = null;
        try {
            Type t = this.getField(55, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT[] getRelationshipToThePatientStopDate() {
        DT[] ret = null;
        try {
            Type[] t = this.getField(56);
            ret = new DT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRelationshipToThePatientStopDateReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(56);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public DT getRelationshipToThePatientStopDate(int rep) {
        DT ret = null;
        try {
            Type t = this.getField(56, rep);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getIn256_RelationshipToThePatientStopDate(int rep) {
        DT ret = null;
        try {
            Type t = this.getField(56, rep);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn256_RelationshipToThePatientStopDateReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(56);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public DT insertRelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(56, rep);
    }

    public DT insertIn256_RelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(56, rep);
    }

    public DT removeRelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(56, rep);
    }

    public DT removeIn256_RelationshipToThePatientStopDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(56, rep);
    }

    public IS getInsuranceCoContactReason() {
        IS ret = null;
        try {
            Type t = this.getField(57, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn257_InsuranceCoContactReason() {
        IS ret = null;
        try {
            Type t = this.getField(57, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getInsuranceCoContactPhoneNumber() {
        XTN ret = null;
        try {
            Type t = this.getField(58, 0);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn258_InsuranceCoContactPhoneNumber() {
        XTN ret = null;
        try {
            Type t = this.getField(58, 0);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPolicyScope() {
        IS ret = null;
        try {
            Type t = this.getField(59, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn259_PolicyScope() {
        IS ret = null;
        try {
            Type t = this.getField(59, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPolicySource() {
        IS ret = null;
        try {
            Type t = this.getField(60, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn260_PolicySource() {
        IS ret = null;
        try {
            Type t = this.getField(60, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPatientMemberNumber() {
        CX ret = null;
        try {
            Type t = this.getField(61, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getIn261_PatientMemberNumber() {
        CX ret = null;
        try {
            Type t = this.getField(61, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getGuarantorSRelationshipToInsured() {
        IS ret = null;
        try {
            Type t = this.getField(62, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn262_GuarantorSRelationshipToInsured() {
        IS ret = null;
        try {
            Type t = this.getField(62, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN[] getInsuredSTelephoneNumberHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(63);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredSTelephoneNumberHomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(63);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN getInsuredSTelephoneNumberHome(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(63, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn263_InsuredSTelephoneNumberHome(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(63, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn263_InsuredSTelephoneNumberHomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(63);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertInsuredSTelephoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(63, rep);
    }

    public XTN insertIn263_InsuredSTelephoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(63, rep);
    }

    public XTN removeInsuredSTelephoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(63, rep);
    }

    public XTN removeIn263_InsuredSTelephoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(63, rep);
    }

    public XTN[] getInsuredSEmployerTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(64);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredSEmployerTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(64);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN getInsuredSEmployerTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(64, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getIn264_InsuredSEmployerTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(64, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn264_InsuredSEmployerTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(64);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertInsuredSEmployerTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(64, rep);
    }

    public XTN insertIn264_InsuredSEmployerTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(64, rep);
    }

    public XTN removeInsuredSEmployerTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(64, rep);
    }

    public XTN removeIn264_InsuredSEmployerTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(64, rep);
    }

    public CE getMilitaryHandicappedProgram() {
        CE ret = null;
        try {
            Type t = this.getField(65, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getIn265_MilitaryHandicappedProgram() {
        CE ret = null;
        try {
            Type t = this.getField(65, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getSuspendFlag() {
        ID ret = null;
        try {
            Type t = this.getField(66, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn266_SuspendFlag() {
        ID ret = null;
        try {
            Type t = this.getField(66, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getCoPayLimitFlag() {
        ID ret = null;
        try {
            Type t = this.getField(67, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn267_CoPayLimitFlag() {
        ID ret = null;
        try {
            Type t = this.getField(67, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getStoplossLimitFlag() {
        ID ret = null;
        try {
            Type t = this.getField(68, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn268_StoplossLimitFlag() {
        ID ret = null;
        try {
            Type t = this.getField(68, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON[] getInsuredOrganizationNameAndID() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(69);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredOrganizationNameAndIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(69);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XON getInsuredOrganizationNameAndID(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(69, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getIn269_InsuredOrganizationNameAndID(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(69, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn269_InsuredOrganizationNameAndIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(69);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XON insertInsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(69, rep);
    }

    public XON insertIn269_InsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(69, rep);
    }

    public XON removeInsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(69, rep);
    }

    public XON removeIn269_InsuredOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(69, rep);
    }

    public XON[] getInsuredEmployerOrganizationNameAndID() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(70);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getInsuredEmployerOrganizationNameAndIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(70);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XON getInsuredEmployerOrganizationNameAndID(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(70, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getIn270_InsuredEmployerOrganizationNameAndID(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(70, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIn270_InsuredEmployerOrganizationNameAndIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(70);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XON insertInsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(70, rep);
    }

    public XON insertIn270_InsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(70, rep);
    }

    public XON removeInsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(70, rep);
    }

    public XON removeIn270_InsuredEmployerOrganizationNameAndID(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(70, rep);
    }

    public IS getRace() {
        IS ret = null;
        try {
            Type t = this.getField(71, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getIn271_Race() {
        IS ret = null;
        try {
            Type t = this.getField(71, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPatientRelationshipToInsured() {
        ID ret = null;
        try {
            Type t = this.getField(72, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getIn272_PatientRelationshipToInsured() {
        ID ret = null;
        try {
            Type t = this.getField(72, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CX(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new XCN(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(139));
            }
            case 4: {
                return new IS(this.getMessage(), new Integer(137));
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new XPN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new XPN(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new IS(this.getMessage(), new Integer(140));
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(141));
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(142));
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new XPN(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ST(this.getMessage());
            }
            case 24: {
                return new CX(this.getMessage());
            }
            case 25: {
                return new CX(this.getMessage());
            }
            case 26: {
                return new IS(this.getMessage(), new Integer(144));
            }
            case 27: {
                return new CM_RMC(this.getMessage());
            }
            case 28: {
                return new CM_PTA(this.getMessage());
            }
            case 29: {
                return new CM_DDI(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 32: {
                return new IS(this.getMessage(), new Integer(171));
            }
            case 33: {
                return new CE(this.getMessage());
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 37: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 38: {
                return new IS(this.getMessage(), new Integer(6));
            }
            case 39: {
                return new XPN(this.getMessage());
            }
            case 40: {
                return new CE(this.getMessage());
            }
            case 41: {
                return new IS(this.getMessage(), new Integer(189));
            }
            case 42: {
                return new IS(this.getMessage(), new Integer(2));
            }
            case 43: {
                return new DT(this.getMessage());
            }
            case 44: {
                return new DT(this.getMessage());
            }
            case 45: {
                return new ST(this.getMessage());
            }
            case 46: {
                return new JCC(this.getMessage());
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 48: {
                return new XPN(this.getMessage());
            }
            case 49: {
                return new XTN(this.getMessage());
            }
            case 50: {
                return new IS(this.getMessage(), new Integer(222));
            }
            case 51: {
                return new XPN(this.getMessage());
            }
            case 52: {
                return new XTN(this.getMessage());
            }
            case 53: {
                return new IS(this.getMessage(), new Integer(222));
            }
            case 54: {
                return new DT(this.getMessage());
            }
            case 55: {
                return new DT(this.getMessage());
            }
            case 56: {
                return new IS(this.getMessage(), new Integer(232));
            }
            case 57: {
                return new XTN(this.getMessage());
            }
            case 58: {
                return new IS(this.getMessage(), new Integer(312));
            }
            case 59: {
                return new IS(this.getMessage(), new Integer(313));
            }
            case 60: {
                return new CX(this.getMessage());
            }
            case 61: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 62: {
                return new XTN(this.getMessage());
            }
            case 63: {
                return new XTN(this.getMessage());
            }
            case 64: {
                return new CE(this.getMessage());
            }
            case 65: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 66: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 67: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 68: {
                return new XON(this.getMessage());
            }
            case 69: {
                return new XON(this.getMessage());
            }
            case 70: {
                return new IS(this.getMessage(), new Integer(5));
            }
            case 71: {
                return new ID(this.getMessage(), new Integer(0));
            }
        }
        return null;
    }
}

