/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.DT;
import ca.uhn.hl7v2.model.v231.datatype.IS;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.log.HapiLogFactory;

public class PLN
extends AbstractType
implements Composite {
    private Type[] data;

    public PLN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new IS(this.getMessage(), 0);
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new DT(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getPln1_IDNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getTypeOfIDNumber() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getPln2_TypeOfIDNumber() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getStateOtherQualifyingInfo() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getPln3_StateOtherQualifyingInfo() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getExpirationDate() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getPln4_ExpirationDate() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

