/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.segment.IN1;
import ca.uhn.hl7v2.model.v231.segment.IN2;
import ca.uhn.hl7v2.model.v231.segment.IN3;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class DFT_P03_IN1IN2IN3
extends AbstractGroup {
    public DFT_P03_IN1IN2IN3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IN1.class, true, false);
            this.add(IN2.class, false, false);
            this.add(IN3.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P03_IN1IN2IN3 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public IN1 getIN1() {
        IN1 ret = null;
        try {
            ret = (IN1)this.get("IN1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IN2 getIN2() {
        IN2 ret = null;
        try {
            ret = (IN2)this.get("IN2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IN3 getIN3() {
        IN3 ret = null;
        try {
            ret = (IN3)this.get("IN3");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IN3 getIN3(int rep) {
        IN3 ret = null;
        try {
            ret = (IN3)this.get("IN3", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getIN3Reps() {
        int reps = -1;
        try {
            reps = this.getAll("IN3").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertIN3(IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN3", structure, rep);
    }

    public IN3 insertIN3(int rep) throws HL7Exception {
        return (IN3)super.insertRepetition("IN3", rep);
    }

    public IN3 removeIN3(int rep) throws HL7Exception {
        return (IN3)super.removeRepetition("IN3", rep);
    }
}

