/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.group.ORF_R04_OBXNTE;
import ca.uhn.hl7v2.model.v231.segment.CTI;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.OBR;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORF_R04_ORCOBRNTEOBXNTECTI
extends AbstractGroup {
    public ORF_R04_ORCOBRNTEOBXNTECTI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ORF_R04_OBXNTE.class, true, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04_ORCOBRNTEOBXNTECTI - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORF_R04_OBXNTE getOBXNTE() {
        ORF_R04_OBXNTE ret = null;
        try {
            ret = (ORF_R04_OBXNTE)this.get("OBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORF_R04_OBXNTE getOBXNTE(int rep) {
        ORF_R04_OBXNTE ret = null;
        try {
            ret = (ORF_R04_OBXNTE)this.get("OBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBXNTE(ORF_R04_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", structure, rep);
    }

    public ORF_R04_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (ORF_R04_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public ORF_R04_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (ORF_R04_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

