/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.group.PPP_PCB_OBXNTEVAR;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.OBR;
import ca.uhn.hl7v2.model.v231.segment.RXO;
import ca.uhn.hl7v2.model.v231.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPP_PCB_OBRRXONTEVAROBXNTEVAR
extends AbstractGroup {
    public PPP_PCB_OBRRXONTEVAROBXNTEVAR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(RXO.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPP_PCB_OBXNTEVAR.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPP_PCB_OBRRXONTEVAROBXNTEVAR - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXO getRXO() {
        RXO ret = null;
        try {
            ret = (RXO)this.get("RXO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPP_PCB_OBXNTEVAR getOBXNTEVAR() {
        PPP_PCB_OBXNTEVAR ret = null;
        try {
            ret = (PPP_PCB_OBXNTEVAR)this.get("OBXNTEVAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPP_PCB_OBXNTEVAR getOBXNTEVAR(int rep) {
        PPP_PCB_OBXNTEVAR ret = null;
        try {
            ret = (PPP_PCB_OBXNTEVAR)this.get("OBXNTEVAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTEVAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBXNTEVAR(PPP_PCB_OBXNTEVAR structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTEVAR", structure, rep);
    }

    public PPP_PCB_OBXNTEVAR insertOBXNTEVAR(int rep) throws HL7Exception {
        return (PPP_PCB_OBXNTEVAR)super.insertRepetition("OBXNTEVAR", rep);
    }

    public PPP_PCB_OBXNTEVAR removeOBXNTEVAR(int rep) throws HL7Exception {
        return (PPP_PCB_OBXNTEVAR)super.removeRepetition("OBXNTEVAR", rep);
    }
}

