/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.group.RQA_I08_OBXNTE;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.OBR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RQA_I08_OBRNTEOBXNTE
extends AbstractGroup {
    public RQA_I08_OBRNTEOBXNTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RQA_I08_OBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RQA_I08_OBRNTEOBXNTE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RQA_I08_OBXNTE getOBXNTE() {
        RQA_I08_OBXNTE ret = null;
        try {
            ret = (RQA_I08_OBXNTE)this.get("OBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RQA_I08_OBXNTE getOBXNTE(int rep) {
        RQA_I08_OBXNTE ret = null;
        try {
            ret = (RQA_I08_OBXNTE)this.get("OBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBXNTE(RQA_I08_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", structure, rep);
    }

    public RQA_I08_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (RQA_I08_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public RQA_I08_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (RQA_I08_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }
}

