/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_OBXNTE;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.model.v231.segment.RXA;
import ca.uhn.hl7v2.model.v231.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class VXU_V04_ORCRXARXROBXNTE
extends AbstractGroup {
    public VXU_V04_ORCRXARXROBXNTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(RXA.class, true, false);
            this.add(RXR.class, false, false);
            this.add(VXU_V04_OBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXU_V04_ORCRXARXROBXNTE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA() {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_OBXNTE getOBXNTE() {
        VXU_V04_OBXNTE ret = null;
        try {
            ret = (VXU_V04_OBXNTE)this.get("OBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_OBXNTE getOBXNTE(int rep) {
        VXU_V04_OBXNTE ret = null;
        try {
            ret = (VXU_V04_OBXNTE)this.get("OBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBXNTE(VXU_V04_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", structure, rep);
    }

    public VXU_V04_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public VXU_V04_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }
}

