/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.OMS_O01_ORCRQDNTEOBXNTEBLG;
import ca.uhn.hl7v2.model.v231.group.OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMS_O01
extends AbstractMessage {
    public OMS_O01() {
        this(new DefaultModelClassFactory());
    }

    public OMS_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(OMS_O01_ORCRQDNTEOBXNTEBLG.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMS_O01 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
        try {
            ret = (OMS_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMS_O01_ORCRQDNTEOBXNTEBLG getORCRQDNTEOBXNTEBLG() {
        OMS_O01_ORCRQDNTEOBXNTEBLG ret = null;
        try {
            ret = (OMS_O01_ORCRQDNTEOBXNTEBLG)this.get("ORCRQDNTEOBXNTEBLG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMS_O01_ORCRQDNTEOBXNTEBLG getORCRQDNTEOBXNTEBLG(int rep) {
        OMS_O01_ORCRQDNTEOBXNTEBLG ret = null;
        try {
            ret = (OMS_O01_ORCRQDNTEOBXNTEBLG)this.get("ORCRQDNTEOBXNTEBLG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRQDNTEOBXNTEBLGReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRQDNTEOBXNTEBLG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRQDNTEOBXNTEBLG(OMS_O01_ORCRQDNTEOBXNTEBLG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRQDNTEOBXNTEBLG", structure, rep);
    }

    public OMS_O01_ORCRQDNTEOBXNTEBLG insertORCRQDNTEOBXNTEBLG(int rep) throws HL7Exception {
        return (OMS_O01_ORCRQDNTEOBXNTEBLG)super.insertRepetition("ORCRQDNTEOBXNTEBLG", rep);
    }

    public OMS_O01_ORCRQDNTEOBXNTEBLG removeORCRQDNTEOBXNTEBLG(int rep) throws HL7Exception {
        return (OMS_O01_ORCRQDNTEOBXNTEBLG)super.removeRepetition("ORCRQDNTEOBXNTEBLG", rep);
    }
}

