/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG;
import ca.uhn.hl7v2.model.v231.group.RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RDO_O01
extends AbstractMessage {
    public RDO_O01() {
        this(new DefaultModelClassFactory());
    }

    public RDO_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDO_O01 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 ret = null;
        try {
            ret = (RDO_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.get("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG getORCRXONTERXRRXCNTEOBXNTEBLG() {
        RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG ret = null;
        try {
            ret = (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)this.get("ORCRXONTERXRRXCNTEOBXNTEBLG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG getORCRXONTERXRRXCNTEOBXNTEBLG(int rep) {
        RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG ret = null;
        try {
            ret = (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)this.get("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXONTERXRRXCNTEOBXNTEBLGReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXONTERXRRXCNTEOBXNTEBLG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXONTERXRRXCNTEOBXNTEBLG(RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXONTERXRRXCNTEOBXNTEBLG", structure, rep);
    }

    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG insertORCRXONTERXRRXCNTEOBXNTEBLG(int rep) throws HL7Exception {
        return (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)super.insertRepetition("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
    }

    public RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG removeORCRXONTERXRRXCNTEOBXNTEBLG(int rep) throws HL7Exception {
        return (RDO_O01_ORCRXONTERXRRXCNTEOBXNTEBLG)super.removeRepetition("ORCRXONTERXRRXCNTEOBXNTEBLG", rep);
    }
}

