/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.SIU_S12_PIDPD1PV1PV2OBXDG1;
import ca.uhn.hl7v2.model.v231.group.SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.SCH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SIU_S12
extends AbstractMessage {
    public SIU_S12() {
        this(new DefaultModelClassFactory());
    }

    public SIU_S12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SCH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(SIU_S12_PIDPD1PV1PV2OBXDG1.class, false, true);
            this.add(SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SIU_S12 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SCH getSCH() {
        SCH ret = null;
        try {
            ret = (SCH)this.get("SCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 getPIDPD1PV1PV2OBXDG1() {
        SIU_S12_PIDPD1PV1PV2OBXDG1 ret = null;
        try {
            ret = (SIU_S12_PIDPD1PV1PV2OBXDG1)this.get("PIDPD1PV1PV2OBXDG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 getPIDPD1PV1PV2OBXDG1(int rep) {
        SIU_S12_PIDPD1PV1PV2OBXDG1 ret = null;
        try {
            ret = (SIU_S12_PIDPD1PV1PV2OBXDG1)this.get("PIDPD1PV1PV2OBXDG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPIDPD1PV1PV2OBXDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("PIDPD1PV1PV2OBXDG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPIDPD1PV1PV2OBXDG1(SIU_S12_PIDPD1PV1PV2OBXDG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPD1PV1PV2OBXDG1", structure, rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 insertPIDPD1PV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)super.insertRepetition("PIDPD1PV1PV2OBXDG1", rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 removePIDPD1PV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)super.removeRepetition("PIDPD1PV1PV2OBXDG1", rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE() {
        SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE ret = null;
        try {
            ret = (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)this.get("RGSAISNTEAIGNTEAILNTEAIPNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) {
        SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE ret = null;
        try {
            ret = (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)this.get("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRGSAISNTEAIGNTEAILNTEAIPNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("RGSAISNTEAIGNTEAILNTEAIPNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRGSAISNTEAIGNTEAILNTEAIPNTE(SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", structure, rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE insertRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE removeRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)super.removeRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }
}

