/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CSP
extends AbstractSegment {
    public CSP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Study Phase Identifier");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Date/time Study Phase Began");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Date/time Study Phase Ended");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Study Phase Evaluability");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSP - this is probably a bug in the source code generator.", e);
        }
    }

    public CE getStudyPhaseIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getCsp1_StudyPhaseIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getDateTimeStudyPhaseBegan() {
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getCsp2_DateTimeStudyPhaseBegan() {
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getDateTimeStudyPhaseEnded() {
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getCsp3_DateTimeStudyPhaseEnded() {
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getStudyPhaseEvaluability() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getCsp4_StudyPhaseEvaluability() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

