/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.FN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.log.HapiLogFactory;

public class CN
extends AbstractType
implements Composite {
    private Type[] data;

    public CN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[9];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 0);
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new HD(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getCn1_IDNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FN getFamilyName() {
        FN ret = null;
        try {
            ret = (FN)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FN getCn2_FamilyName() {
        FN ret = null;
        try {
            ret = (FN)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getGivenName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getCn3_GivenName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getCn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSuffixEgJRorIII() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getCn5_SuffixEgJRorIII() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getPrefixEgDR() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getCn6_PrefixEgDR() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getDegreeEgMD() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getCn7_DegreeEgMD() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getSourceTable() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getCn8_SourceTable() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(7);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getAssigningAuthority() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public HD getCn9_AssigningAuthority() {
        HD ret = null;
        try {
            ret = (HD)this.getComponent(8);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

