/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NR;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TX;
import ca.uhn.log.HapiLogFactory;

public class RFR
extends AbstractType
implements Composite {
    private Type[] data;

    public RFR(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[7];
        this.data[0] = new NR(this.getMessage());
        this.data[1] = new IS(this.getMessage(), 0);
        this.data[2] = new NR(this.getMessage());
        this.data[3] = new NR(this.getMessage());
        this.data[4] = new TX(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new TX(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public NR getNumericRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NR getRfr1_NumericRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getAdministrativeSex() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getRfr2_AdministrativeSex() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NR getAgeRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NR getRfr3_AgeRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NR getGestationalRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NR getRfr4_GestationalRange() {
        NR ret = null;
        try {
            ret = (NR)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getSpecies() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getRfr5_Species() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getRaceSubspecies() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getRfr6_RaceSubspecies() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getConditions() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getRfr7_Conditions() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(6);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

