/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.ORG_O20_ORDER;
import ca.uhn.hl7v2.model.v24.group.ORG_O20_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORG_O20_RESPONSE
extends AbstractGroup {
    public ORG_O20_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORG_O20_PATIENT.class, false, false);
            this.add(ORG_O20_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORG_O20_RESPONSE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORG_O20_PATIENT getPATIENT() {
        ORG_O20_PATIENT ret = null;
        try {
            ret = (ORG_O20_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORG_O20_ORDER getORDER() {
        ORG_O20_ORDER ret = null;
        try {
            ret = (ORG_O20_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORG_O20_ORDER getORDER(int rep) {
        ORG_O20_ORDER ret = null;
        try {
            ret = (ORG_O20_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(ORG_O20_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public ORG_O20_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORG_O20_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORG_O20_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORG_O20_ORDER)super.removeRepetition("ORDER", rep);
    }
}

