/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.RSP_Z88_ALLERGY;
import ca.uhn.hl7v2.model.v24.group.RSP_Z88_COMMON_ORDER;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.PD1;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Z88_QUERY_RESPONSE
extends AbstractGroup {
    public RSP_Z88_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NTE.class, false, true);
            this.add(RSP_Z88_ALLERGY.class, false, false);
            this.add(RSP_Z88_COMMON_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RSP_Z88_QUERY_RESPONSE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RSP_Z88_ALLERGY getALLERGY() {
        RSP_Z88_ALLERGY ret = null;
        try {
            ret = (RSP_Z88_ALLERGY)this.get("ALLERGY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_COMMON_ORDER getCOMMON_ORDER() {
        RSP_Z88_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z88_COMMON_ORDER)this.get("COMMON_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_COMMON_ORDER getCOMMON_ORDER(int rep) {
        RSP_Z88_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z88_COMMON_ORDER)this.get("COMMON_ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCOMMON_ORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("COMMON_ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCOMMON_ORDER(RSP_Z88_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", structure, rep);
    }

    public RSP_Z88_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z88_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public RSP_Z88_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z88_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }
}

