/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.EAR_U08_COMMAND_RESPONSE;
import ca.uhn.hl7v2.model.v24.segment.EQU;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EAR_U08
extends AbstractMessage {
    public EAR_U08() {
        this(new DefaultModelClassFactory());
    }

    public EAR_U08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EQU.class, true, false);
            this.add(EAR_U08_COMMAND_RESPONSE.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EAR_U08 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EQU getEQU() {
        EQU ret = null;
        try {
            ret = (EQU)this.get("EQU");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE() {
        EAR_U08_COMMAND_RESPONSE ret = null;
        try {
            ret = (EAR_U08_COMMAND_RESPONSE)this.get("COMMAND_RESPONSE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EAR_U08_COMMAND_RESPONSE getCOMMAND_RESPONSE(int rep) {
        EAR_U08_COMMAND_RESPONSE ret = null;
        try {
            ret = (EAR_U08_COMMAND_RESPONSE)this.get("COMMAND_RESPONSE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCOMMAND_RESPONSEReps() {
        int reps = -1;
        try {
            reps = this.getAll("COMMAND_RESPONSE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCOMMAND_RESPONSE(EAR_U08_COMMAND_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMAND_RESPONSE", structure, rep);
    }

    public EAR_U08_COMMAND_RESPONSE insertCOMMAND_RESPONSE(int rep) throws HL7Exception {
        return (EAR_U08_COMMAND_RESPONSE)super.insertRepetition("COMMAND_RESPONSE", rep);
    }

    public EAR_U08_COMMAND_RESPONSE removeCOMMAND_RESPONSE(int rep) throws HL7Exception {
        return (EAR_U08_COMMAND_RESPONSE)super.removeRepetition("COMMAND_RESPONSE", rep);
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

