/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_PATIENT;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_VISIT;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OUL_R21
extends AbstractMessage {
    public OUL_R21() {
        this(new DefaultModelClassFactory());
    }

    public OUL_R21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, false);
            this.add(OUL_R21_PATIENT.class, false, false);
            this.add(OUL_R21_VISIT.class, false, false);
            this.add(OUL_R21_ORDER_OBSERVATION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OUL_R21 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_PATIENT getPATIENT() {
        OUL_R21_PATIENT ret = null;
        try {
            ret = (OUL_R21_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_VISIT getVISIT() {
        OUL_R21_VISIT ret = null;
        try {
            ret = (OUL_R21_VISIT)this.get("VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_ORDER_OBSERVATION getORDER_OBSERVATION() {
        OUL_R21_ORDER_OBSERVATION ret = null;
        try {
            ret = (OUL_R21_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_ORDER_OBSERVATION getORDER_OBSERVATION(int rep) {
        OUL_R21_ORDER_OBSERVATION ret = null;
        try {
            ret = (OUL_R21_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER_OBSERVATION(OUL_R21_ORDER_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_OBSERVATION", structure, rep);
    }

    public OUL_R21_ORDER_OBSERVATION insertORDER_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_ORDER_OBSERVATION)super.insertRepetition("ORDER_OBSERVATION", rep);
    }

    public OUL_R21_ORDER_OBSERVATION removeORDER_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_ORDER_OBSERVATION)super.removeRepetition("ORDER_OBSERVATION", rep);
    }

    public DSC getDSC() {
        DSC ret = null;
        try {
            ret = (DSC)this.get("DSC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

