/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.RSP_Z90_COMMON_ORDER;
import ca.uhn.hl7v2.model.v25.group.RSP_Z90_PATIENT;
import ca.uhn.hl7v2.model.v25.group.RSP_Z90_SPECIMEN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Z90_QUERY_RESPONSE
extends AbstractGroup {
    public RSP_Z90_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RSP_Z90_PATIENT.class, false, false);
            this.add(RSP_Z90_COMMON_ORDER.class, true, true);
            this.add(RSP_Z90_SPECIMEN.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RSP_Z90_QUERY_RESPONSE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public RSP_Z90_PATIENT getPATIENT() {
        RSP_Z90_PATIENT ret = null;
        try {
            ret = (RSP_Z90_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z90_COMMON_ORDER getCOMMON_ORDER() {
        RSP_Z90_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z90_COMMON_ORDER)this.get("COMMON_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z90_COMMON_ORDER getCOMMON_ORDER(int rep) {
        RSP_Z90_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z90_COMMON_ORDER)this.get("COMMON_ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCOMMON_ORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("COMMON_ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCOMMON_ORDER(RSP_Z90_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", structure, rep);
    }

    public RSP_Z90_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z90_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public RSP_Z90_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z90_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }

    public RSP_Z90_SPECIMEN getSPECIMEN() {
        RSP_Z90_SPECIMEN ret = null;
        try {
            ret = (RSP_Z90_SPECIMEN)this.get("SPECIMEN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z90_SPECIMEN getSPECIMEN(int rep) {
        RSP_Z90_SPECIMEN ret = null;
        try {
            ret = (RSP_Z90_SPECIMEN)this.get("SPECIMEN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMENReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSPECIMEN(RSP_Z90_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public RSP_Z90_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (RSP_Z90_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public RSP_Z90_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (RSP_Z90_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }
}

