/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.BRT_O32_TIMING;
import ca.uhn.hl7v2.model.v251.segment.BPO;
import ca.uhn.hl7v2.model.v251.segment.BTX;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class BRT_O32_ORDER
extends AbstractGroup {
    public BRT_O32_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(BRT_O32_TIMING.class, false, true);
            this.add(BPO.class, false, false);
            this.add(BTX.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BRT_O32_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRT_O32_TIMING getTIMING() {
        BRT_O32_TIMING ret = null;
        try {
            ret = (BRT_O32_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRT_O32_TIMING getTIMING(int rep) {
        BRT_O32_TIMING ret = null;
        try {
            ret = (BRT_O32_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(BRT_O32_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public BRT_O32_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRT_O32_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRT_O32_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRT_O32_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO ret = null;
        try {
            ret = (BPO)this.get("BPO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BTX getBTX() {
        BTX ret = null;
        try {
            ret = (BTX)this.get("BTX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BTX getBTX(int rep) {
        BTX ret = null;
        try {
            ret = (BTX)this.get("BTX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getBTXReps() {
        int reps = -1;
        try {
            reps = this.getAll("BTX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertBTX(BTX structure, int rep) throws HL7Exception {
        super.insertRepetition("BTX", structure, rep);
    }

    public BTX insertBTX(int rep) throws HL7Exception {
        return (BTX)super.insertRepetition("BTX", rep);
    }

    public BTX removeBTX(int rep) throws HL7Exception {
        return (BTX)super.removeRepetition("BTX", rep);
    }
}

