/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.segment.CDM;
import ca.uhn.hl7v2.model.v251.segment.MFE;
import ca.uhn.hl7v2.model.v251.segment.PRC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFR_M04_MF_QUERY
extends AbstractGroup {
    public MFR_M04_MF_QUERY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(CDM.class, true, false);
            this.add(PRC.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFR_M04_MF_QUERY - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CDM getCDM() {
        CDM ret = null;
        try {
            ret = (CDM)this.get("CDM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRC getPRC() {
        PRC ret = null;
        try {
            ret = (PRC)this.get("PRC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRC getPRC(int rep) {
        PRC ret = null;
        try {
            ret = (PRC)this.get("PRC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRCReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRC(PRC structure, int rep) throws HL7Exception {
        super.insertRepetition("PRC", structure, rep);
    }

    public PRC insertPRC(int rep) throws HL7Exception {
        return (PRC)super.insertRepetition("PRC", rep);
    }

    public PRC removePRC(int rep) throws HL7Exception {
        return (PRC)super.removeRepetition("PRC", rep);
    }
}

