/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.OML_O21_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.OML_O21_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v251.group.OML_O21_SPECIMEN;
import ca.uhn.hl7v2.model.v251.segment.CTD;
import ca.uhn.hl7v2.model.v251.segment.DG1;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.OBR;
import ca.uhn.hl7v2.model.v251.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OML_O21_OBSERVATION_REQUEST
extends AbstractGroup {
    public OML_O21_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(TCD.class, false, false);
            this.add(NTE.class, false, true);
            this.add(CTD.class, false, false);
            this.add(DG1.class, false, true);
            this.add(OML_O21_OBSERVATION.class, false, true);
            this.add(OML_O21_SPECIMEN.class, false, true);
            this.add(OML_O21_PRIOR_RESULT.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OML_O21_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TCD getTCD() {
        TCD ret = null;
        try {
            ret = (TCD)this.get("TCD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTD getCTD() {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OML_O21_OBSERVATION getOBSERVATION() {
        OML_O21_OBSERVATION ret = null;
        try {
            ret = (OML_O21_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_OBSERVATION getOBSERVATION(int rep) {
        OML_O21_OBSERVATION ret = null;
        try {
            ret = (OML_O21_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(OML_O21_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public OML_O21_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OML_O21_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OML_O21_SPECIMEN getSPECIMEN() {
        OML_O21_SPECIMEN ret = null;
        try {
            ret = (OML_O21_SPECIMEN)this.get("SPECIMEN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_SPECIMEN getSPECIMEN(int rep) {
        OML_O21_SPECIMEN ret = null;
        try {
            ret = (OML_O21_SPECIMEN)this.get("SPECIMEN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMENReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSPECIMEN(OML_O21_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", structure, rep);
    }

    public OML_O21_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OML_O21_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT() {
        OML_O21_PRIOR_RESULT ret = null;
        try {
            ret = (OML_O21_PRIOR_RESULT)this.get("PRIOR_RESULT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT(int rep) {
        OML_O21_PRIOR_RESULT ret = null;
        try {
            ret = (OML_O21_PRIOR_RESULT)this.get("PRIOR_RESULT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRIOR_RESULTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRIOR_RESULT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRIOR_RESULT(OML_O21_PRIOR_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRIOR_RESULT", structure, rep);
    }

    public OML_O21_PRIOR_RESULT insertPRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.insertRepetition("PRIOR_RESULT", rep);
    }

    public OML_O21_PRIOR_RESULT removePRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.removeRepetition("PRIOR_RESULT", rep);
    }
}

