/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.segment.TQ1;
import ca.uhn.hl7v2.model.v251.segment.TQ2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OUL_R21_TIMING_QTY
extends AbstractGroup {
    public OUL_R21_TIMING_QTY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TQ1.class, true, false);
            this.add(TQ2.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OUL_R21_TIMING_QTY - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public TQ1 getTQ1() {
        TQ1 ret = null;
        try {
            ret = (TQ1)this.get("TQ1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ2 getTQ2() {
        TQ2 ret = null;
        try {
            ret = (TQ2)this.get("TQ2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ2 getTQ2(int rep) {
        TQ2 ret = null;
        try {
            ret = (TQ2)this.get("TQ2", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTQ2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("TQ2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTQ2(TQ2 structure, int rep) throws HL7Exception {
        super.insertRepetition("TQ2", structure, rep);
    }

    public TQ2 insertTQ2(int rep) throws HL7Exception {
        return (TQ2)super.insertRepetition("TQ2", rep);
    }

    public TQ2 removeTQ2(int rep) throws HL7Exception {
        return (TQ2)super.removeRepetition("TQ2", rep);
    }
}

