/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_GOAL;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_PATHWAY_ROLE;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.PTH;
import ca.uhn.hl7v2.model.v251.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPG_PCG_PATHWAY
extends AbstractGroup {
    public PPG_PCG_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPG_PCG_PATHWAY_ROLE.class, false, true);
            this.add(PPG_PCG_GOAL.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPG_PCG_PATHWAY - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PTH getPTH() {
        PTH ret = null;
        try {
            ret = (PTH)this.get("PTH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCG_PATHWAY_ROLE getPATHWAY_ROLE() {
        PPG_PCG_PATHWAY_ROLE ret = null;
        try {
            ret = (PPG_PCG_PATHWAY_ROLE)this.get("PATHWAY_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_PATHWAY_ROLE getPATHWAY_ROLE(int rep) {
        PPG_PCG_PATHWAY_ROLE ret = null;
        try {
            ret = (PPG_PCG_PATHWAY_ROLE)this.get("PATHWAY_ROLE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATHWAY_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATHWAY_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATHWAY_ROLE(PPG_PCG_PATHWAY_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY_ROLE", structure, rep);
    }

    public PPG_PCG_PATHWAY_ROLE insertPATHWAY_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY_ROLE)super.insertRepetition("PATHWAY_ROLE", rep);
    }

    public PPG_PCG_PATHWAY_ROLE removePATHWAY_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PATHWAY_ROLE)super.removeRepetition("PATHWAY_ROLE", rep);
    }

    public PPG_PCG_GOAL getGOAL() {
        PPG_PCG_GOAL ret = null;
        try {
            ret = (PPG_PCG_GOAL)this.get("GOAL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_GOAL getGOAL(int rep) {
        PPG_PCG_GOAL ret = null;
        try {
            ret = (PPG_PCG_GOAL)this.get("GOAL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOALReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL(PPG_PCG_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", structure, rep);
    }

    public PPG_PCG_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PPG_PCG_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL)super.removeRepetition("GOAL", rep);
    }
}

