/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.RER_RER_ORDER;
import ca.uhn.hl7v2.model.v251.group.RER_RER_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RER_RER_DEFINITION
extends AbstractGroup {
    public RER_RER_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(RER_RER_PATIENT.class, false, false);
            this.add(RER_RER_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RER_RER_DEFINITION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public QRD getQRD() {
        QRD ret = null;
        try {
            ret = (QRD)this.get("QRD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QRF getQRF() {
        QRF ret = null;
        try {
            ret = (QRF)this.get("QRF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RER_RER_PATIENT getPATIENT() {
        RER_RER_PATIENT ret = null;
        try {
            ret = (RER_RER_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RER_RER_ORDER getORDER() {
        RER_RER_ORDER ret = null;
        try {
            ret = (RER_RER_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RER_RER_ORDER getORDER(int rep) {
        RER_RER_ORDER ret = null;
        try {
            ret = (RER_RER_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(RER_RER_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RER_RER_ORDER insertORDER(int rep) throws HL7Exception {
        return (RER_RER_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RER_RER_ORDER removeORDER(int rep) throws HL7Exception {
        return (RER_RER_ORDER)super.removeRepetition("ORDER", rep);
    }
}

