/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.RSP_Z88_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.RSP_Z88_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RSP_Z88_ORDER_ENCODED;
import ca.uhn.hl7v2.model.v251.group.RSP_Z88_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.model.v251.segment.RXC;
import ca.uhn.hl7v2.model.v251.segment.RXD;
import ca.uhn.hl7v2.model.v251.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Z88_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z88_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RSP_Z88_TIMING.class, false, true);
            this.add(RSP_Z88_ORDER_DETAIL.class, false, false);
            this.add(RSP_Z88_ORDER_ENCODED.class, false, false);
            this.add(RXD.class, true, false);
            this.add(RXR.class, true, true);
            this.add(RXC.class, false, true);
            this.add(RSP_Z88_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RSP_Z88_COMMON_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_TIMING getTIMING() {
        RSP_Z88_TIMING ret = null;
        try {
            ret = (RSP_Z88_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_TIMING getTIMING(int rep) {
        RSP_Z88_TIMING ret = null;
        try {
            ret = (RSP_Z88_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(RSP_Z88_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RSP_Z88_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z88_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z88_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z88_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RSP_Z88_ORDER_DETAIL getORDER_DETAIL() {
        RSP_Z88_ORDER_DETAIL ret = null;
        try {
            ret = (RSP_Z88_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_ORDER_ENCODED getORDER_ENCODED() {
        RSP_Z88_ORDER_ENCODED ret = null;
        try {
            ret = (RSP_Z88_ORDER_ENCODED)this.get("ORDER_ENCODED");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXD getRXD() {
        RXD ret = null;
        try {
            ret = (RXD)this.get("RXD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR(int rep) {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXC getRXC(int rep) {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXCReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RSP_Z88_OBSERVATION getOBSERVATION() {
        RSP_Z88_OBSERVATION ret = null;
        try {
            ret = (RSP_Z88_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z88_OBSERVATION ret = null;
        try {
            ret = (RSP_Z88_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(RSP_Z88_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RSP_Z88_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z88_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z88_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z88_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

