/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CQ;
import ca.uhn.hl7v2.model.v251.datatype.CWE;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.LA1;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.PL;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TQ;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XAD;
import ca.uhn.hl7v2.model.v251.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RXE
extends AbstractSegment {
    public RXE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TQ.class, false, 1, 200, new Object[]{this.getMessage(), new Integer(0)}, "Quantity/Timing");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage(), new Integer(292)}, "Give Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Give Amount - Maximum");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Units");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Dosage Form");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Provider's Administration Instructions");
            this.add(LA1.class, false, 1, 200, new Object[]{this.getMessage(), new Integer(0)}, "Deliver-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Substitution Status");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Dispense Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Dispense Units");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(0)}, "Number Of Refills");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Ordering Provider's DEA Number");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Pharmacist/Treatment Supplier's Verifier ID");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Prescription Number");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Number of Refills Remaining");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Number of Refills/Doses Dispensed");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "D/T of Most Recent Refill or Dose Dispensed");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(0)}, "Total Daily Dose");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Needs Human Review");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Pharmacy/Treatment Supplier's Special Dispensing Instructions");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Give Per (Time Unit)");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage(), new Integer(0)}, "Give Rate Amount");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Rate Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Give Strength");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Strength Units");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Indication");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Dispense Package Size");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Dispense Package Size Unit");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage()}, "Dispense Package Method");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Supplementary Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Original Order Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "Give Drug Strength Volume");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Give Drug Strength Volume Units");
            this.add(CWE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(477)}, "Controlled Substance Schedule");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Formulary Status");
            this.add(CWE.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(0)}, "Pharmaceutical Substance Alternative");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Pharmacy of Most Recent Fill");
            this.add(NM.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Initial Dispense Amount");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Dispensing Pharmacy");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Dispensing Pharmacy Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(0)}, "Deliver-to Patient Location");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Deliver-to Address");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Pharmacy Order Type");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RXE - this is probably a bug in the source code generator.", e);
        }
    }

    public TQ getQuantityTiming() {
        TQ ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TQ getRxe1_QuantityTiming() {
        TQ ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGiveCode() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe2_GiveCode() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGiveAmountMinimum() {
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe3_GiveAmountMinimum() {
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGiveAmountMaximum() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe4_GiveAmountMaximum() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGiveUnits() {
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe5_GiveUnits() {
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGiveDosageForm() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe6_GiveDosageForm() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getProviderSAdministrationInstructions() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getProviderSAdministrationInstructionsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE getProviderSAdministrationInstructions(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe7_ProviderSAdministrationInstructions(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe7_ProviderSAdministrationInstructionsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE insertRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(7, rep);
    }

    public CE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public CE removeRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(7, rep);
    }

    public LA1 getDeliverToLocation() {
        LA1 ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (LA1)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public LA1 getRxe8_DeliverToLocation() {
        LA1 ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (LA1)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getSubstitutionStatus() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRxe9_SubstitutionStatus() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getDispenseAmount() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe10_DispenseAmount() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getDispenseUnits() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe11_DispenseUnits() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getNumberOfRefills() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe12_NumberOfRefills() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getOrderingProviderSDEANumber() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(13);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOrderingProviderSDEANumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getOrderingProviderSDEANumber(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getRxe13_OrderingProviderSDEANumber(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe13_OrderingProviderSDEANumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN insertRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(13, rep);
    }

    public XCN removeOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN removeRxe13_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(13, rep);
    }

    public XCN[] getPharmacistTreatmentSupplierSVerifierID() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(14);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPharmacistTreatmentSupplierSVerifierIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getPharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe14_PharmacistTreatmentSupplierSVerifierIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertPharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removePharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeRxe14_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public ST getPrescriptionNumber() {
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getRxe15_PrescriptionNumber() {
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getNumberOfRefillsRemaining() {
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe16_NumberOfRefillsRemaining() {
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getNumberOfRefillsDosesDispensed() {
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe17_NumberOfRefillsDosesDispensed() {
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getDTOfMostRecentRefillOrDoseDispensed() {
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getRxe18_DTOfMostRecentRefillOrDoseDispensed() {
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getTotalDailyDose() {
        CQ ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getRxe19_TotalDailyDose() {
        CQ ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getNeedsHumanReview() {
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRxe20_NeedsHumanReview() {
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getPharmacyTreatmentSupplierSSpecialDispensingInstructions() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE getPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructionsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE insertPharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE insertRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(21, rep);
    }

    public CE removePharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public CE removeRxe21_PharmacyTreatmentSupplierSSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(21, rep);
    }

    public ST getGivePerTimeUnit() {
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getRxe22_GivePerTimeUnit() {
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getGiveRateAmount() {
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getRxe23_GiveRateAmount() {
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGiveRateUnits() {
        CE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe24_GiveRateUnits() {
        CE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGiveStrength() {
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe25_GiveStrength() {
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGiveStrengthUnits() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe26_GiveStrengthUnits() {
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getGiveIndication() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(27);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getGiveIndicationReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE getGiveIndication(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe27_GiveIndication(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe27_GiveIndicationReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE insertGiveIndication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE insertRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE removeGiveIndication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public CE removeRxe27_GiveIndication(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public NM getDispensePackageSize() {
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe28_DispensePackageSize() {
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getDispensePackageSizeUnit() {
        CE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe29_DispensePackageSizeUnit() {
        CE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getDispensePackageMethod() {
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRxe30_DispensePackageMethod() {
        ID ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getSupplementaryCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(31);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSupplementaryCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE getSupplementaryCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRxe31_SupplementaryCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe31_SupplementaryCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE insertRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(31, rep);
    }

    public CE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public CE removeRxe31_SupplementaryCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(31, rep);
    }

    public TS getOriginalOrderDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getRxe32_OriginalOrderDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGiveDrugStrengthVolume() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe33_GiveDrugStrengthVolume() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getGiveDrugStrengthVolumeUnits() {
        CWE ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getRxe34_GiveDrugStrengthVolumeUnits() {
        CWE ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getControlledSubstanceSchedule() {
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getRxe35_ControlledSubstanceSchedule() {
        CWE ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getFormularyStatus() {
        ID ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRxe36_FormularyStatus() {
        ID ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getPharmaceuticalSubstanceAlternative() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(37);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPharmaceuticalSubstanceAlternativeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(37);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE getPharmaceuticalSubstanceAlternative(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(37, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getRxe37_PharmaceuticalSubstanceAlternative(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(37, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRxe37_PharmaceuticalSubstanceAlternativeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(37);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertPharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(37, rep);
    }

    public CWE insertRxe37_PharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(37, rep);
    }

    public CWE removePharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(37, rep);
    }

    public CWE removeRxe37_PharmaceuticalSubstanceAlternative(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(37, rep);
    }

    public CWE getPharmacyOfMostRecentFill() {
        CWE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getRxe38_PharmacyOfMostRecentFill() {
        CWE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInitialDispenseAmount() {
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getRxe39_InitialDispenseAmount() {
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getDispensingPharmacy() {
        CWE ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getRxe40_DispensingPharmacy() {
        CWE ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getDispensingPharmacyAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getRxe41_DispensingPharmacyAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getDeliverToPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getRxe42_DeliverToPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getDeliverToAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getRxe43_DeliverToAddress() {
        XAD ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPharmacyOrderType() {
        ID ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRxe44_PharmacyOrderType() {
        ID ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TQ(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new LA1(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new XCN(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new TS(this.getMessage());
            }
            case 18: {
                return new CQ(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new CE(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CE(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(321));
            }
            case 30: {
                return new CE(this.getMessage());
            }
            case 31: {
                return new TS(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new CWE(this.getMessage());
            }
            case 34: {
                return new CWE(this.getMessage());
            }
            case 35: {
                return new ID(this.getMessage(), new Integer(478));
            }
            case 36: {
                return new CWE(this.getMessage());
            }
            case 37: {
                return new CWE(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new CWE(this.getMessage());
            }
            case 40: {
                return new XAD(this.getMessage());
            }
            case 41: {
                return new PL(this.getMessage());
            }
            case 42: {
                return new XAD(this.getMessage());
            }
            case 43: {
                return new ID(this.getMessage(), new Integer(480));
            }
        }
        return null;
    }
}

