/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.segment.PCE;
import ca.uhn.hl7v2.model.v26.segment.PKG;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M16_PACKAGING
extends AbstractGroup {
    public MFN_M16_PACKAGING(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PKG.class, true, false);
            this.add(PCE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M16_PACKAGING - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PKG getPKG() {
        PKG ret = null;
        try {
            ret = (PKG)this.get("PKG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PCE getPCE() {
        PCE ret = null;
        try {
            ret = (PCE)this.get("PCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PCE getPCE(int rep) {
        PCE ret = null;
        try {
            ret = (PCE)this.get("PCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPCE(PCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PCE", structure, rep);
    }

    public PCE insertPCE(int rep) throws HL7Exception {
        return (PCE)super.insertRepetition("PCE", rep);
    }

    public PCE removePCE(int rep) throws HL7Exception {
        return (PCE)super.removeRepetition("PCE", rep);
    }
}

