/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.segment.LCC;
import ca.uhn.hl7v2.model.v26.segment.LCH;
import ca.uhn.hl7v2.model.v26.segment.LDP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Q11_MF_LOC_DEPT
extends AbstractGroup {
    public RSP_Q11_MF_LOC_DEPT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(LDP.class, true, false);
            this.add(LCH.class, false, true);
            this.add(LCC.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RSP_Q11_MF_LOC_DEPT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public LDP getLDP() {
        LDP ret = null;
        try {
            ret = (LDP)this.get("LDP");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH() {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH(int rep) {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLCHReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCH").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LCC getLCC() {
        LCC ret = null;
        try {
            ret = (LCC)this.get("LCC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCC getLCC(int rep) {
        LCC ret = null;
        try {
            ret = (LCC)this.get("LCC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLCCReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLCC(LCC structure, int rep) throws HL7Exception {
        super.insertRepetition("LCC", structure, rep);
    }

    public LCC insertLCC(int rep) throws HL7Exception {
        return (LCC)super.insertRepetition("LCC", rep);
    }

    public LCC removeLCC(int rep) throws HL7Exception {
        return (LCC)super.removeRepetition("LCC", rep);
    }
}

