/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E15_ADJUSTMENT_PAYEE;
import ca.uhn.hl7v2.model.v26.group.EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PMT;
import ca.uhn.hl7v2.model.v26.segment.PYE;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E15
extends AbstractMessage {
    public EHC_E15() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E15(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(PMT.class, true, false);
            this.add(PYE.class, true, false);
            this.add(EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO.class, false, true);
            this.add(EHC_E15_ADJUSTMENT_PAYEE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E15 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UAC getUAC(int rep) {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getUACReps() {
        int reps = -1;
        try {
            reps = this.getAll("UAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public PMT getPMT() {
        PMT ret = null;
        try {
            ret = (PMT)this.get("PMT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PYE getPYE() {
        PYE ret = null;
        try {
            ret = (PYE)this.get("PYE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO getPAYMENT_REMITTANCE_DETAIL_INFO() {
        EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO ret = null;
        try {
            ret = (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)this.get("PAYMENT_REMITTANCE_DETAIL_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO getPAYMENT_REMITTANCE_DETAIL_INFO(int rep) {
        EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO ret = null;
        try {
            ret = (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)this.get("PAYMENT_REMITTANCE_DETAIL_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPAYMENT_REMITTANCE_DETAIL_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PAYMENT_REMITTANCE_DETAIL_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPAYMENT_REMITTANCE_DETAIL_INFO(EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", structure, rep);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO insertPAYMENT_REMITTANCE_DETAIL_INFO(int rep) throws HL7Exception {
        return (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)super.insertRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", rep);
    }

    public EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO removePAYMENT_REMITTANCE_DETAIL_INFO(int rep) throws HL7Exception {
        return (EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO)super.removeRepetition("PAYMENT_REMITTANCE_DETAIL_INFO", rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE getADJUSTMENT_PAYEE() {
        EHC_E15_ADJUSTMENT_PAYEE ret = null;
        try {
            ret = (EHC_E15_ADJUSTMENT_PAYEE)this.get("ADJUSTMENT_PAYEE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E15_ADJUSTMENT_PAYEE getADJUSTMENT_PAYEE(int rep) {
        EHC_E15_ADJUSTMENT_PAYEE ret = null;
        try {
            ret = (EHC_E15_ADJUSTMENT_PAYEE)this.get("ADJUSTMENT_PAYEE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getADJUSTMENT_PAYEEReps() {
        int reps = -1;
        try {
            reps = this.getAll("ADJUSTMENT_PAYEE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertADJUSTMENT_PAYEE(EHC_E15_ADJUSTMENT_PAYEE structure, int rep) throws HL7Exception {
        super.insertRepetition("ADJUSTMENT_PAYEE", structure, rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE insertADJUSTMENT_PAYEE(int rep) throws HL7Exception {
        return (EHC_E15_ADJUSTMENT_PAYEE)super.insertRepetition("ADJUSTMENT_PAYEE", rep);
    }

    public EHC_E15_ADJUSTMENT_PAYEE removeADJUSTMENT_PAYEE(int rep) throws HL7Exception {
        return (EHC_E15_ADJUSTMENT_PAYEE)super.removeRepetition("ADJUSTMENT_PAYEE", rep);
    }
}

