/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CM0
extends AbstractSegment {
    public CM0(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - CM0");
            this.add(EI.class, true, 1, 427, new Object[]{this.getMessage(), new Integer(0)}, "Sponsor Study ID");
            this.add(EI.class, false, 3, 427, new Object[]{this.getMessage(), new Integer(0)}, "Alternate Study ID");
            this.add(ST.class, true, 1, 300, new Object[]{this.getMessage(), new Integer(0)}, "Title of Study");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Chairman of Study");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Last IRB Approval Date");
            this.add(NM.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Total Accrual to Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Last Accrual Date");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Contact for Study");
            this.add(XTN.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Contact's Telephone Number");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Contact's Address");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CM0 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDCM0() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getCm01_SetIDCM0() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getSponsorStudyID() {
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getCm02_SponsorStudyID() {
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI[] getAlternateStudyID() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (EI)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAlternateStudyIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public EI getAlternateStudyID(int rep) {
        EI ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getCm03_AlternateStudyID(int rep) {
        EI ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCm03_AlternateStudyIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public EI insertAlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI insertCm03_AlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(3, rep);
    }

    public EI removeAlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public EI removeCm03_AlternateStudyID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(3, rep);
    }

    public ST getTitleOfStudy() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getCm04_TitleOfStudy() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getChairmanOfStudy() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getChairmanOfStudyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getChairmanOfStudy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getCm05_ChairmanOfStudy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCm05_ChairmanOfStudyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertCm05_ChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeCm05_ChairmanOfStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public DT getLastIRBApprovalDate() {
        DT ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getCm06_LastIRBApprovalDate() {
        DT ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTotalAccrualToDate() {
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getCm07_TotalAccrualToDate() {
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getLastAccrualDate() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getCm08_LastAccrualDate() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getContactForStudy() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactForStudyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getContactForStudy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getCm09_ContactForStudy(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCm09_ContactForStudyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertCm09_ContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removeCm09_ContactForStudy(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XTN getContactSTelephoneNumber() {
        XTN ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getCm010_ContactSTelephoneNumber() {
        XTN ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD[] getContactSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(11);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactSAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XAD getContactSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getCm011_ContactSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCm011_ContactSAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertCm011_ContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeCm011_ContactSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new DT(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new XTN(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

