/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PTH
extends AbstractSegment {
    public PTH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage()}, "Action Code");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage(), new Integer(0)}, "Pathway ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Pathway Instance ID");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Pathway Established Date/Time");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(0)}, "Pathway Life Cycle Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Change Pathway Life Cycle Status Date/Time");
            this.add(CNE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(725)}, "Mood Code");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PTH - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getActionCode() {
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPth1_ActionCode() {
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPathwayID() {
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPth2_PathwayID() {
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getPathwayInstanceID() {
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getPth3_PathwayInstanceID() {
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getPathwayEstablishedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getPth4_PathwayEstablishedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPathwayLifeCycleStatus() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPth5_PathwayLifeCycleStatus() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getChangePathwayLifeCycleStatusDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getPth6_ChangePathwayLifeCycleStatusDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getMoodCode() {
        CNE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getPth7_MoodCode() {
        CNE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

