/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.util.MessageNavigator;
import java.util.regex.Pattern;

public class SegmentFinder
extends MessageNavigator {
    public SegmentFinder(Group root) {
        super(root);
    }

    public Segment findSegment(String namePattern, int rep) throws HL7Exception {
        Structure s = null;
        while (!Segment.class.isAssignableFrom((s = this.findStructure(namePattern, rep)).getClass())) {
        }
        return (Segment)s;
    }

    public Group findGroup(String namePattern, int rep) throws HL7Exception {
        Structure s = null;
        while (!Group.class.isAssignableFrom((s = this.findStructure(namePattern, rep)).getClass())) {
        }
        return (Group)s;
    }

    private Structure findStructure(String namePattern, int rep) throws HL7Exception {
        Structure s = null;
        while (s == null) {
            this.iterate(false, false);
            String currentName = this.getCurrentStructure(0).getName();
            if (!this.matches(namePattern, currentName)) continue;
            s = this.getCurrentStructure(rep);
        }
        return s;
    }

    public Segment getSegment(String namePattern, int rep) throws HL7Exception {
        Structure s = this.getStructure(namePattern, rep);
        if (!Segment.class.isAssignableFrom(s.getClass())) {
            throw new HL7Exception(s.getName() + " is not a segment", 207);
        }
        return (Segment)s;
    }

    public Group getGroup(String namePattern, int rep) throws HL7Exception {
        Structure s = this.getStructure(namePattern, rep);
        if (!Group.class.isAssignableFrom(s.getClass())) {
            throw new HL7Exception(s.getName() + " is not a group", 207);
        }
        return (Group)s;
    }

    private Structure getStructure(String namePattern, int rep) throws HL7Exception {
        Structure s = null;
        if (this.getCurrentStructure(0).equals(this.getRoot())) {
            this.drillDown(0);
        }
        String[] names = this.getCurrentStructure(0).getParent().getNames();
        for (int i = 0; i < names.length && s == null; ++i) {
            if (!this.matches(namePattern, names[i])) continue;
            this.toChild(i);
            s = this.getCurrentStructure(rep);
        }
        if (s == null) {
            throw new HL7Exception("Can't find " + namePattern + " as a direct child", 207);
        }
        return s;
    }

    private boolean matches(String pattern, String candidate) {
        if (pattern.equals(candidate)) {
            return true;
        }
        if (!Pattern.matches("[\\w\\*\\?]*", pattern)) {
            throw new IllegalArgumentException("The pattern " + pattern + " is not valid.  Only [\\w\\*\\?]* allowed.");
        }
        pattern = Pattern.compile("\\*").matcher(pattern).replaceAll(".*");
        pattern = Pattern.compile("\\?").matcher(pattern).replaceAll(".");
        return Pattern.matches(pattern, candidate);
    }
}

