/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.view;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class TreePanel
extends JPanel {
    private static final HapiLog log = HapiLogFactory.getHapiLog(TreePanel.class);
    private PipeParser parser;
    private EncodingCharacters encChars;
    private Message message;

    public TreePanel(PipeParser parser) {
        this.parser = parser;
        this.encChars = new EncodingCharacters('|', null);
    }

    public void setMessage(Message message) {
        this.message = message;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(message.getClass().getName());
        this.addChildren(message, (MutableTreeNode)top);
        JTree tree = new JTree(top);
        this.removeAll();
        this.add(tree);
        this.revalidate();
    }

    public Message getMessage() {
        return this.message;
    }

    private void addChildren(Group messParent, MutableTreeNode treeParent) {
        String[] childNames = messParent.getNames();
        int currChild = 0;
        for (int i = 0; i < childNames.length; ++i) {
            try {
                Structure[] childReps = messParent.getAll(childNames[i]);
                for (int j = 0; j < childReps.length; ++j) {
                    DefaultMutableTreeNode newNode = null;
                    if (childReps[j] instanceof Group) {
                        String groupName = childReps[j].getClass().getName();
                        groupName = groupName.substring(groupName.lastIndexOf(46) + 1, groupName.length());
                        newNode = new DefaultMutableTreeNode(groupName + " (rep " + j + ")");
                        this.addChildren((Group)childReps[j], (MutableTreeNode)newNode);
                    } else if (childReps[j] instanceof Segment) {
                        newNode = new DefaultMutableTreeNode(PipeParser.encode((Segment)childReps[j], this.encChars));
                        this.addChildren((Segment)childReps[j], (MutableTreeNode)newNode);
                    }
                    treeParent.insert(newNode, currChild++);
                }
                continue;
            }
            catch (HL7Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addChildren(Segment messParent, MutableTreeNode treeParent) {
        int n = messParent.numFields();
        int currChild = 0;
        for (int i = 1; i <= n; ++i) {
            try {
                Type[] reps = messParent.getField(i);
                for (int j = 0; j < reps.length; ++j) {
                    String field = PipeParser.encode(reps[j], this.encChars);
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("Field " + i + " rep " + j + " (" + TreePanel.getLabel(reps[j]) + "): " + field);
                    this.addChildren(reps[j], (MutableTreeNode)newNode);
                    treeParent.insert(newNode, currChild++);
                }
                continue;
            }
            catch (HL7Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addChildren(Type messParent, MutableTreeNode treeParent) {
        if (Varies.class.isAssignableFrom(messParent.getClass())) {
            Type data = ((Varies)messParent).getData();
            DefaultMutableTreeNode dataNode = new DefaultMutableTreeNode(TreePanel.getLabel(data));
            treeParent.insert(dataNode, 0);
            this.addChildren(data, (MutableTreeNode)dataNode);
        } else {
            if (Composite.class.isAssignableFrom(messParent.getClass())) {
                this.addChildren((Composite)messParent, treeParent);
            } else if (Primitive.class.isAssignableFrom(messParent.getClass())) {
                this.addChildren((Primitive)messParent, treeParent);
            }
            if (messParent.getExtraComponents().numComponents() > 0) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("ExtraComponents");
                treeParent.insert(newNode, treeParent.getChildCount());
                for (int i = 0; i < messParent.getExtraComponents().numComponents(); ++i) {
                    DefaultMutableTreeNode variesNode = new DefaultMutableTreeNode("Varies");
                    newNode.insert(variesNode, i);
                    this.addChildren(messParent.getExtraComponents().getComponent(i), (MutableTreeNode)variesNode);
                }
            }
        }
    }

    private void addChildren(Composite messParent, MutableTreeNode treeParent) {
        Type[] components = messParent.getComponents();
        for (int i = 0; i < components.length; ++i) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(TreePanel.getLabel(components[i]));
            this.addChildren(components[i], (MutableTreeNode)newNode);
            treeParent.insert(newNode, i);
        }
    }

    private void addChildren(Primitive messParent, MutableTreeNode treeParent) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(messParent.getValue());
        treeParent.insert(newNode, 0);
    }

    private static String getLabel(Object o) {
        String name = o.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public static void showInNewWindow(Message message) {
        JFrame frame = new JFrame(message.getClass().getName());
        try {
            TreePanel panel = new TreePanel(new PipeParser());
            panel.setMessage(message);
            JScrollPane scroll = new JScrollPane(panel);
            frame.getContentPane().add((Component)scroll, "Center");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.err.println("Can't display message in new window: ");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: TreePanel msg_file_name");
            System.exit(1);
        }
        try {
            PipeParser parser = new PipeParser();
            File messageFile = new File(args[0]);
            long fileLength = messageFile.length();
            FileReader r = new FileReader(messageFile);
            char[] cbuf = new char[(int)fileLength];
            System.out.println("Reading message file ... " + r.read(cbuf) + " of " + fileLength + " chars");
            r.close();
            String messString = String.valueOf(cbuf);
            Message mess = parser.parse(messString);
            System.out.println("Got message of type " + mess.getClass().getName());
            TreePanel.showInNewWindow(mess);
            System.out.println(parser.encode(mess, "VB"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e);
        }
    }
}

