/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;

public class SolrEndpoint
extends DefaultEndpoint {
    private CommonsHttpSolrServer solrServer;
    private String requestHandler;

    public SolrEndpoint() {
    }

    public SolrEndpoint(String uri, SolrComponent component) {
        super(uri, (Component)component);
    }

    public SolrEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public SolrEndpoint(String endpointUri, SolrComponent component, String address) throws Exception {
        super(endpointUri, (Component)component);
        this.solrServer = new CommonsHttpSolrServer("http://" + address);
    }

    public Producer createProducer() throws Exception {
        return new SolrProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Solr endpoint.");
    }

    public boolean isSingleton() {
        return true;
    }

    public CommonsHttpSolrServer getSolrServer() {
        return this.solrServer;
    }

    public void setMaxRetries(int maxRetries) {
        this.solrServer.setMaxRetries(maxRetries);
    }

    public void setSoTimeout(int soTimeout) {
        this.solrServer.setSoTimeout(soTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.solrServer.setConnectionTimeout(connectionTimeout);
    }

    public void setDefaultMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
        this.solrServer.setDefaultMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.solrServer.setMaxTotalConnections(maxTotalConnections);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.solrServer.setFollowRedirects(followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        this.solrServer.setAllowCompression(allowCompression);
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }
}

